/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.LruCache;
import com.bin.david.form.core.TableConfig;

public class BitmapDrawer {
    private Rect imgRect;
    private Rect drawRect;
    private BitmapFactory.Options options = new BitmapFactory.Options();
    private LruCache<Integer, Bitmap> cache;

    public BitmapDrawer() {
        this.imgRect = new Rect();
        this.drawRect = new Rect();
        int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        int cacheSize = maxMemory / 16;
        this.cache = new LruCache<Integer, Bitmap>(cacheSize){

            protected int sizeOf(Integer key, Bitmap bitmap) {
                return bitmap.getRowBytes() * bitmap.getHeight() / 1024;
            }
        };
    }

    public void drawRes(Context context, Canvas c, Rect rect, int resID, TableConfig config) {
        Bitmap bitmap = (Bitmap)this.cache.get((Object)resID);
        if (bitmap == null) {
            bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resID, (BitmapFactory.Options)this.options);
            if (bitmap != null) {
                this.cache.put((Object)resID, (Object)bitmap);
            }
            this.drawBitmap(c, rect, bitmap, config);
        }
    }

    public void drawBitmap(Canvas c, Rect rect, Bitmap bitmap, TableConfig config) {
        Paint paint = config.getPaint();
        if (bitmap != null) {
            paint.setColor(-16777216);
            paint.setStyle(Paint.Style.FILL);
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            this.imgRect.set(0, 0, width, height);
            float scaleX = (float)width / (float)rect.width();
            float scaleY = (float)height / (float)rect.height();
            if (scaleX > 1.0f || scaleY > 1.0f) {
                if (scaleX > scaleY) {
                    width = (int)((float)width / scaleX);
                    height = rect.height();
                } else {
                    height = (int)((float)height / scaleY);
                    width = rect.width();
                }
            }
            width = (int)((float)width * config.getZoom());
            height = (int)((float)height * config.getZoom());
            int disX = (rect.right - rect.left - width) / 2;
            int disY = (rect.bottom - rect.top - height) / 2;
            this.drawRect.left = rect.left + disX;
            this.drawRect.top = rect.top + disY;
            this.drawRect.right = rect.right - disX;
            this.drawRect.bottom = rect.bottom - disY;
            c.drawBitmap(bitmap, this.imgRect, this.drawRect, paint);
        }
    }
}

