/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.table;

import com.bin.david.form.data.column.ArrayColumn;
import com.bin.david.form.data.column.Column;
import com.bin.david.form.data.column.MapColumn;
import com.bin.david.form.data.format.IFormat;
import com.bin.david.form.data.format.draw.IDrawFormat;
import com.bin.david.form.data.table.TableData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MapTableData
extends TableData<Object> {
    private FilterColumnIntercept mIntercept;

    public static MapTableData create(String tableName, List<Object> mapList) {
        return MapTableData.create(tableName, mapList, null);
    }

    public static MapTableData create(String tableName, List<Object> mapList, IFormat<String> keyFormat) {
        if (mapList != null) {
            ArrayList<Column> columns = new ArrayList<Column>();
            MapTableData.getMapColumn(columns, "", "", mapList, keyFormat);
            return new MapTableData(tableName, mapList, (List<Column>)columns);
        }
        return null;
    }

    private static void getMapColumn(List<Column> columns, String fieldName, String parentKey, List<Object> mapList, IFormat<String> keyFormat) {
        Object o;
        if (mapList != null && mapList.size() > 0 && (o = mapList.get(0)) != null) {
            if (o instanceof Map) {
                Map map = (Map)o;
                boolean isOneArray = true;
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    Object val = entry.getValue();
                    if (ArrayColumn.isList(val)) {
                        if (!isOneArray) continue;
                        List list = (List)val;
                        MapTableData.getMapColumn(columns, fieldName + key + ".", key, list, keyFormat);
                        isOneArray = false;
                        continue;
                    }
                    String columnName = keyFormat == null ? key : keyFormat.format(key);
                    MapColumn column = new MapColumn(columnName, fieldName + key);
                    columns.add(column);
                }
            } else {
                String columnName = keyFormat == null ? parentKey : keyFormat.format(parentKey);
                MapColumn column = new MapColumn(columnName, fieldName, false);
                columns.add(column);
            }
        }
    }

    private MapTableData(String tableName, List t, List<Column> columns) {
        super(tableName, t, columns);
    }

    public void setDrawFormat(IDrawFormat drawFormat) {
        for (Column column : this.getColumns()) {
            column.setDrawFormat(drawFormat);
        }
    }

    public void setFormat(IFormat format) {
        for (Column column : this.getColumns()) {
            column.setFormat(format);
        }
    }

    public void setMinWidth(int minWidth) {
        for (Column column : this.getColumns()) {
            column.setMinWidth(minWidth);
        }
    }

    public void setMinHeight(int minHeight) {
        for (Column column : this.getColumns()) {
            column.setMinHeight(minHeight);
        }
    }

    public FilterColumnIntercept getFilterColumnIntercept() {
        return this.mIntercept;
    }

    public void setFilterColumnIntercept(FilterColumnIntercept intercept) {
        this.mIntercept = intercept;
        if (this.mIntercept != null) {
            for (int i = this.getColumns().size() - 1; i >= 0; --i) {
                Column column = this.getColumns().get(i);
                if (!this.mIntercept.onIntercept(column, column.getColumnName())) continue;
                this.getColumns().remove(i);
            }
        }
    }

    public static interface FilterColumnIntercept {
        public boolean onIntercept(Column var1, String var2);
    }
}

