/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.style;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import com.bin.david.form.data.style.IStyle;
import com.bin.david.form.utils.DensityUtils;

public class PointStyle
implements IStyle {
    public static final int CIRCLE = 0;
    public static final int SQUARE = 1;
    public static final int RECT = 2;
    private float width;
    private int color;
    private int shape;
    private Paint.Style style;
    private static float defaultPointSize = 10.0f;
    private static int defaultPointColor = Color.parseColor((String)"#888888");
    private boolean isDraw = true;

    public PointStyle() {
    }

    public PointStyle(float width, int color) {
        this.width = width;
        this.color = color;
    }

    public PointStyle(Context context, float dp, int color) {
        this.width = DensityUtils.dp2px(context, dp);
        this.color = color;
    }

    public static void setDefaultPointSize(float width) {
        defaultPointSize = width;
    }

    public static void setDefaultLineSize(Context context, float dp) {
        defaultPointSize = DensityUtils.dp2px(context, dp);
    }

    public static void setDefaultPointColor(int color) {
        defaultPointColor = color;
    }

    public float getWidth() {
        if (this.width == 0.0f) {
            return defaultPointSize;
        }
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setWidth(Context context, int dp) {
        this.width = DensityUtils.dp2px(context, dp);
    }

    public int getColor() {
        if (this.color == 0) {
            return defaultPointColor;
        }
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int shape) {
        this.shape = shape;
    }

    public Paint.Style getStyle() {
        if (this.style == null) {
            return Paint.Style.FILL;
        }
        return this.style;
    }

    public void setStyle(Paint.Style style) {
        this.style = style;
    }

    public boolean isDraw() {
        return this.isDraw;
    }

    public void setDraw(boolean draw) {
        this.isDraw = draw;
    }

    @Override
    public void fillPaint(Paint paint) {
        paint.setColor(this.getColor());
        paint.setStyle(this.getStyle());
        paint.setStrokeWidth(this.getWidth());
    }
}

