/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.format.tip;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.bin.david.form.data.format.tip.BaseBubbleTip;
import com.bin.david.form.data.style.FontStyle;

public abstract class SingleLineBubbleTip<C>
extends BaseBubbleTip<C, String> {
    public SingleLineBubbleTip(Context context, int backgroundDrawableID, int triangleDrawableID, FontStyle style) {
        super(context, backgroundDrawableID, triangleDrawableID, style);
    }

    @Override
    public int getTextHeight(String content) {
        Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
        return (int)(fontMetrics.bottom - fontMetrics.top);
    }

    @Override
    public int getTextWidth(String content) {
        return (int)this.getPaint().measureText(content);
    }

    @Override
    public void drawText(Canvas canvas, Rect tipRect, String content, int textWidth, int textHeight, Paint paint) {
        paint.setTextAlign(Paint.Align.LEFT);
        canvas.drawText(content, (float)(tipRect.centerX() - textWidth / 2), (float)(tipRect.centerY() + textHeight / 2 - this.deviation / 2), paint);
    }
}

