/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.format.draw;

import android.graphics.Canvas;
import android.graphics.Rect;
import com.bin.david.form.core.TableConfig;
import com.bin.david.form.data.CellInfo;
import com.bin.david.form.data.column.Column;
import com.bin.david.form.data.format.draw.ImageResDrawFormat;
import com.bin.david.form.data.format.draw.TextDrawFormat;
import com.bin.david.form.exception.TableException;

public abstract class TextImageDrawFormat<T>
extends ImageResDrawFormat<T> {
    public static final int LEFT = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;
    private TextDrawFormat<T> textDrawFormat = new TextDrawFormat();
    private int drawPadding;
    private int direction;
    private Rect rect = new Rect();

    public TextImageDrawFormat(int imageWidth, int imageHeight, int drawPadding) {
        this(imageWidth, imageHeight, 0, drawPadding);
    }

    public TextImageDrawFormat(int imageWidth, int imageHeight, int direction, int drawPadding) {
        super(imageWidth, imageHeight);
        this.direction = direction;
        this.drawPadding = drawPadding;
        if (direction > 3 || direction < 0) {
            throw new TableException("Please set the direction less than 3 greater than 0");
        }
    }

    @Override
    public int measureWidth(Column<T> column, int position, TableConfig config) {
        int textWidth = this.textDrawFormat.measureWidth(column, position, config);
        if (this.direction == 0 || this.direction == 2) {
            return this.getImageWidth() + textWidth + this.drawPadding;
        }
        return Math.max(super.measureWidth(column, position, config), textWidth);
    }

    @Override
    public int measureHeight(Column<T> column, int position, TableConfig config) {
        int imgHeight = super.measureHeight(column, position, config);
        int textHeight = this.textDrawFormat.measureHeight(column, position, config);
        if (this.direction == 1 || this.direction == 3) {
            return this.getImageHeight() + textHeight + this.drawPadding;
        }
        return Math.max(imgHeight, textHeight);
    }

    @Override
    public void draw(Canvas c, Rect rect, CellInfo<T> cellInfo, TableConfig config) {
        if (this.getBitmap(cellInfo.data, cellInfo.value, cellInfo.row) == null) {
            this.textDrawFormat.draw(c, rect, cellInfo, config);
            return;
        }
        int imgWidth = (int)((float)this.getImageWidth() * config.getZoom());
        int imgHeight = (int)((float)this.getImageHeight() * config.getZoom());
        rect.left += config.getHorizontalPadding();
        rect.right -= config.getHorizontalPadding();
        rect.top += config.getVerticalPadding();
        rect.bottom -= config.getVerticalPadding();
        switch (this.direction) {
            case 0: {
                this.rect.set(rect.left + (imgWidth + this.drawPadding), rect.top, rect.right, rect.bottom);
                this.textDrawFormat.draw(c, this.rect, cellInfo, config);
                int imgRight = (rect.right + rect.left) / 2 - this.textDrawFormat.measureWidth(cellInfo.column, cellInfo.row, config) / 2 + this.drawPadding;
                this.rect.set(imgRight - imgWidth, rect.top, imgRight, rect.bottom);
                super.draw(c, this.rect, cellInfo, config);
                break;
            }
            case 2: {
                this.rect.set(rect.left, rect.top, rect.right - (imgWidth + this.drawPadding), rect.bottom);
                this.textDrawFormat.draw(c, this.rect, cellInfo, config);
                int imgLeft = (rect.right + rect.left) / 2 + this.textDrawFormat.measureWidth(cellInfo.column, cellInfo.row, config) / 2 + this.drawPadding;
                this.rect.set(imgLeft, rect.top, imgLeft + imgWidth, rect.bottom);
                super.draw(c, this.rect, cellInfo, config);
                break;
            }
            case 1: {
                this.rect.set(rect.left, rect.top + (imgHeight + this.drawPadding) / 2, rect.right, rect.bottom);
                this.textDrawFormat.draw(c, this.rect, cellInfo, config);
                int imgBottom = (rect.top + rect.bottom) / 2 - this.textDrawFormat.measureHeight(cellInfo.column, cellInfo.row, config) / 2 + this.drawPadding;
                this.rect.set(rect.left, imgBottom - imgHeight, rect.right, imgBottom);
                super.draw(c, this.rect, cellInfo, config);
                break;
            }
            case 3: {
                this.rect.set(rect.left, rect.top, rect.right, rect.bottom - (imgHeight + this.drawPadding) / 2);
                this.textDrawFormat.draw(c, this.rect, cellInfo, config);
                int imgTop = (rect.top + rect.bottom) / 2 + this.textDrawFormat.measureHeight(cellInfo.column, cellInfo.row, config) / 2 - this.drawPadding;
                this.rect.set(rect.left, imgTop, rect.right, imgTop + imgHeight);
                super.draw(c, this.rect, cellInfo, config);
            }
        }
    }
}

