/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.format.draw;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.bin.david.form.core.TableConfig;
import com.bin.david.form.data.column.Column;
import com.bin.david.form.data.format.draw.TextDrawFormat;
import com.bin.david.form.utils.DrawUtils;

public class FastTextDrawFormat<T>
extends TextDrawFormat<T> {
    private int height;
    private int width;
    private int maxLengthValue;

    @Override
    public int measureWidth(Column<T> column, int position, TableConfig config) {
        String value = column.format(position);
        if (value.length() > this.maxLengthValue) {
            this.maxLengthValue = value.length();
            Paint paint = config.getPaint();
            config.getContentStyle().fillPaint(paint);
            this.width = (int)paint.measureText(value);
        }
        return this.width;
    }

    @Override
    public int measureHeight(Column<T> column, int position, TableConfig config) {
        if (this.height == 0) {
            Paint paint = config.getPaint();
            config.getContentStyle().fillPaint(paint);
            this.height = DrawUtils.getTextHeight(paint);
        }
        return this.height;
    }

    @Override
    protected void drawText(Canvas c, String value, Rect rect, Paint paint) {
        DrawUtils.drawSingleText(c, paint, rect, value);
    }
}

