/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.format.draw;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.bin.david.form.core.TableConfig;
import com.bin.david.form.data.CellInfo;
import com.bin.david.form.data.column.Column;
import com.bin.david.form.data.format.draw.IDrawFormat;

public abstract class BitmapDrawFormat<T>
implements IDrawFormat<T> {
    private int imageWidth;
    private int imageHeight;
    private Rect imgRect;
    private Rect drawRect;

    public BitmapDrawFormat(int imageWidth, int imageHeight) {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.imgRect = new Rect();
        this.drawRect = new Rect();
    }

    @Override
    public int measureWidth(Column<T> column, int position, TableConfig config) {
        return this.imageWidth;
    }

    @Override
    public int measureHeight(Column<T> column, int position, TableConfig config) {
        return this.imageHeight;
    }

    protected abstract Bitmap getBitmap(T var1, String var2, int var3);

    @Override
    public void draw(Canvas c, Rect rect, CellInfo<T> cellInfo, TableConfig config) {
        Bitmap bitmap;
        Paint paint = config.getPaint();
        Bitmap bitmap2 = bitmap = cellInfo == null ? this.getBitmap(null, null, 0) : this.getBitmap(cellInfo.data, cellInfo.value, cellInfo.row);
        if (bitmap != null) {
            paint.setColor(-16777216);
            paint.setStyle(Paint.Style.FILL);
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            this.imgRect.set(0, 0, width, height);
            float scaleX = (float)width / (float)this.imageWidth;
            float scaleY = (float)height / (float)this.imageHeight;
            if (scaleX > 1.0f || scaleY > 1.0f) {
                if (scaleX > scaleY) {
                    width = (int)((float)width / scaleX);
                    height = this.imageHeight;
                } else {
                    height = (int)((float)height / scaleY);
                    width = this.imageWidth;
                }
            }
            width = (int)((float)width * config.getZoom());
            height = (int)((float)height * config.getZoom());
            int disX = (rect.right - rect.left - width) / 2;
            int disY = (rect.bottom - rect.top - height) / 2;
            this.drawRect.left = rect.left + disX;
            this.drawRect.top = rect.top + disY;
            this.drawRect.right = rect.right - disX;
            this.drawRect.bottom = rect.bottom - disY;
            c.drawBitmap(bitmap, this.imgRect, this.drawRect, paint);
        }
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }
}

