/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.data.format.count;

import com.bin.david.form.data.column.Column;
import com.bin.david.form.data.format.count.ICountFormat;
import java.util.HashSet;
import java.util.Set;

public class StringCountFormat<T>
implements ICountFormat<T, Integer> {
    private Set<String> valueSet;
    private int count;
    private Column<T> column;

    public StringCountFormat(Column<T> column) {
        this.column = column;
        this.valueSet = new HashSet<String>();
    }

    @Override
    public void count(T t) {
        String value;
        if (this.column.getFormat() != null) {
            value = this.column.getFormat().format(t);
        } else {
            String string = value = t == null ? "" : t.toString();
        }
        if (value != null && !this.valueSet.contains(value) && !"".equals(value)) {
            ++this.count;
            this.valueSet.add(value);
        }
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public String getCountString() {
        return String.valueOf(this.count);
    }

    @Override
    public void clearCount() {
        this.valueSet.clear();
        this.count = 0;
    }
}

