/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.core;

import com.bin.david.form.annotation.ColumnType;
import com.bin.david.form.annotation.SmartColumn;
import com.bin.david.form.annotation.SmartTable;
import com.bin.david.form.data.column.ArrayColumn;
import com.bin.david.form.data.column.Column;
import com.bin.david.form.data.table.PageTableData;
import com.bin.david.form.exception.TableException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotationParser<T> {
    private int dp10;

    public PageTableData<T> parse(List<T> dataList) {
        Class<?> clazz;
        SmartTable tableAnnotation;
        T firstData;
        if (dataList != null && dataList.size() > 0 && (firstData = dataList.get(0)) != null && (tableAnnotation = (clazz = firstData.getClass()).getAnnotation(SmartTable.class)) != null) {
            SmartTable table = tableAnnotation;
            ArrayList<Column> columns = new ArrayList<Column>();
            PageTableData<T> tableData = new PageTableData<T>(table.name(), dataList, columns);
            tableData.setCurrentPage(table.currentPage());
            tableData.setPageSize(table.pageSize());
            tableData.setShowCount(table.count());
            HashMap<String, Column> parentMap = new HashMap<String, Column>();
            this.getColumnAnnotation(clazz, null, columns, parentMap, false);
            Collections.sort(columns);
            return tableData;
        }
        return null;
    }

    private void getColumnAnnotation(Class clazz, String parentFieldName, List<Column> columns, Map<String, Column> parentMap, boolean isArray) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldName;
            field.setAccessible(true);
            Class<?> fieldClass = field.getType();
            SmartColumn fieldAnnotation = field.getAnnotation(SmartColumn.class);
            if (fieldAnnotation == null) continue;
            SmartColumn smartColumn = fieldAnnotation;
            ColumnType type = smartColumn.type();
            if (type == ColumnType.Own) {
                fieldName = parentFieldName != null ? parentFieldName + field.getName() : field.getName();
                this.createColumn(fieldName, field, columns, parentMap, isArray, true, smartColumn);
                continue;
            }
            if (type == ColumnType.Child) {
                fieldName = (parentFieldName != null ? parentFieldName : "") + field.getName() + ".";
                this.getColumnAnnotation(fieldClass, fieldName, columns, parentMap, isArray);
                continue;
            }
            if (type != ColumnType.ArrayChild && type != ColumnType.ArrayOwn) continue;
            fieldClass = this.getParameterizedType(field);
            fieldName = (parentFieldName != null ? parentFieldName : "") + field.getName();
            if (type == ColumnType.ArrayOwn) {
                this.createColumn(fieldName, field, columns, parentMap, true, false, smartColumn);
                continue;
            }
            this.getColumnAnnotation(fieldClass, fieldName + ".", columns, parentMap, true);
        }
    }

    private void createColumn(String fieldName, Field field, List<Column> columns, Map<String, Column> parentMap, boolean isArray, boolean isThoroughArray, SmartColumn smartColumn) {
        Column<?> column;
        String name = smartColumn.name();
        int id = smartColumn.id();
        String parent = smartColumn.parent();
        boolean isAutoCount = smartColumn.autoCount();
        boolean isFast = smartColumn.fast();
        if (name.equals("")) {
            name = field.getName();
        }
        if ((column = this.getGenericColumn(name, fieldName, isArray)) instanceof ArrayColumn) {
            ((ArrayColumn)column).setThoroughArray(isThoroughArray);
        }
        column.setId(id);
        column.setFast(isFast);
        column.setTextAlign(smartColumn.align());
        column.setAutoMerge(smartColumn.autoMerge());
        column.setMinWidth(smartColumn.minWidth() * this.dp10 / 10);
        column.setMinHeight(smartColumn.minHeight() * this.dp10 / 10);
        column.setTitleAlign(smartColumn.titleAlign());
        column.setWidth(smartColumn.width() * this.dp10 / 10);
        if (smartColumn.maxMergeCount() != -1) {
            column.setMaxMergeCount(smartColumn.maxMergeCount());
        }
        column.setAutoCount(isAutoCount);
        column.setFixed(smartColumn.fixed());
        if (!parent.equals("")) {
            Column parentColumn = parentMap.get(parent);
            if (parentColumn == null) {
                ArrayList<Column> childColumns = new ArrayList<Column>();
                childColumns.add(column);
                parentColumn = new Column(parent, childColumns);
                parentColumn.setId(id);
                columns.add(parentColumn);
                parentMap.put(parent, parentColumn);
            } else {
                parentColumn.addChildren(column);
            }
            if (id < parentColumn.getId()) {
                parentColumn.setId(id);
            }
        } else {
            columns.add(column);
        }
    }

    private Class<?> getParameterizedType(Field field) {
        if (field.getType() == List.class) {
            Type genericType = field.getGenericType();
            if (genericType == null) {
                throw new TableException("ColumnType Array field List  must be with generics");
            }
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                return genericClazz;
            }
            throw new TableException("ColumnType Array field List  must be with generics");
        }
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        throw new TableException("ColumnType Array field  must be List or Array");
    }

    private Column<?> getGenericColumn(String name, String fieldName, boolean isArray) {
        Column column = isArray ? new ArrayColumn(name, fieldName) : new Column(name, fieldName);
        return column;
    }

    public AnnotationParser(int dp10) {
        this.dp10 = dp10;
    }
}

