/*
 * Decompiled with CFR 0.152.
 */
package com.bin.david.form.component;

import android.graphics.Rect;
import com.bin.david.form.data.Cell;
import com.bin.david.form.data.column.Column;
import com.bin.david.form.data.table.TableData;
import java.util.List;

public class GridDrawer<T> {
    private TableData<T> tableData;
    private Cell[][] rangePoints;

    public void setTableData(TableData<T> tableData) {
        this.tableData = tableData;
        this.rangePoints = tableData.getTableInfo().getRangeCells();
    }

    public Rect correctCellRect(int row, int col, Rect rect, float zoom) {
        Cell point;
        if (this.rangePoints != null && this.rangePoints.length > row && (point = this.rangePoints[row][col]) != null) {
            if (point.col != -1 && point.row != -1) {
                int i;
                List<Column> childColumns = this.tableData.getChildColumns();
                int[] lineHeights = this.tableData.getTableInfo().getLineHeightArray();
                int width = 0;
                int height = 0;
                for (i = col; i < Math.min(childColumns.size(), col + point.col); ++i) {
                    width += childColumns.get(i).getComputeWidth();
                }
                for (i = row; i < Math.min(lineHeights.length, row + point.row); ++i) {
                    height += lineHeights[i];
                }
                rect.right = (int)((float)rect.left + (float)width * zoom);
                rect.bottom = (int)((float)rect.top + (float)height * zoom);
                return rect;
            }
            return null;
        }
        return rect;
    }
}

