/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.widget.view;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.iplayer.utils.PlayerUtils;
import com.android.iplayer.widget.R;

public class BatteryView
extends LinearLayout {
    private BatteryReceiver mBatteryReceiver;
    private TextView mBatteryText;
    private TextView mBatteryTime;
    private ImageView mBatteryStatus;

    public BatteryView(Context context) {
        this(context, null);
    }

    public BatteryView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BatteryView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)R.layout.player_battery_view, (ViewGroup)this);
        this.mBatteryText = (TextView)this.findViewById(R.id.battery_text);
        this.mBatteryTime = (TextView)this.findViewById(R.id.battery_time);
        this.mBatteryStatus = (ImageView)this.findViewById(R.id.battery_status);
        this.updateSystemTime();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (null == this.mBatteryReceiver) {
            this.mBatteryReceiver = new BatteryReceiver();
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
            intentFilter.addAction("android.intent.action.TIME_TICK");
            intentFilter.addAction("android.intent.action.TIME_SET");
            this.getContext().registerReceiver((BroadcastReceiver)this.mBatteryReceiver, intentFilter);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (null != this.mBatteryReceiver) {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.mBatteryReceiver);
            this.mBatteryReceiver = null;
        }
    }

    public void showTime(boolean showTime) {
        if (!showTime && null != this.mBatteryTime) {
            this.mBatteryTime.setVisibility(8);
            this.mBatteryTime = null;
        }
    }

    private void updateSystemTime() {
        if (null != this.mBatteryTime) {
            this.mBatteryTime.setText((CharSequence)PlayerUtils.getInstance().getCurrentTimeStr());
        }
    }

    private class BatteryReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.BATTERY_CHANGED".equals(intent.getAction())) {
                Bundle extras = intent.getExtras();
                if (null != BatteryView.this.mBatteryText && null != extras) {
                    boolean isCharging;
                    int current = extras.getInt("level");
                    int total = extras.getInt("scale");
                    int percent = current * 100 / total;
                    BatteryView.this.mBatteryText.setText((CharSequence)(percent + "%"));
                    int status = intent.getIntExtra("status", -1);
                    boolean bl = isCharging = status == 2 || status == 5;
                    if (null != BatteryView.this.mBatteryStatus) {
                        BatteryView.this.mBatteryStatus.setVisibility(isCharging ? 0 : 4);
                    }
                }
            } else if ("android.intent.action.TIME_TICK".equals(intent.getAction()) || "android.intent.action.TIME_SET".equals(intent.getAction())) {
                BatteryView.this.updateSystemTime();
            }
        }
    }
}

