/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.media.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.RequiresApi;
import com.android.iplayer.base.AbstractMediaPlayer;
import com.android.iplayer.utils.PlayerUtils;
import java.io.IOException;
import java.util.Map;

public class MediaPlayer
extends AbstractMediaPlayer
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnVideoSizeChangedListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnErrorListener {
    private android.media.MediaPlayer mMediaPlayer = new android.media.MediaPlayer();
    private int mBuffer;

    public MediaPlayer(Context context) {
        super(context);
        this.mMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mMediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
        this.mMediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this);
        this.mMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
        this.mMediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this);
        this.mMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
    }

    @Override
    public void setLooping(boolean loop) {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setLooping(loop);
        }
    }

    @Override
    public void setVolume(float leftVolume, float rightVolume) {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setVolume(leftVolume, rightVolume);
        }
    }

    @Override
    public void setBufferTimeMax(float timeSecond) {
    }

    @Override
    public void setSurface(Surface surface) {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setSurface(surface);
        }
    }

    @Override
    public void setDisplay(SurfaceHolder surfaceHolder) {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setDisplay(surfaceHolder);
        }
    }

    @Override
    public void setDataSource(String dataSource) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        if (null != this.mMediaPlayer) {
            try {
                Uri uri = Uri.parse((String)dataSource);
                this.mMediaPlayer.setDataSource(null == this.getContext() ? PlayerUtils.getInstance().getContext() : this.getContext(), uri);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setDataSource(String path, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        if (null != this.mMediaPlayer) {
            try {
                this.mMediaPlayer.setDataSource(this.getContext(), Uri.parse((String)path), headers);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setDataSource(AssetFileDescriptor dataSource) throws IOException, IllegalArgumentException, IllegalStateException {
        if (null != this.mMediaPlayer && Build.VERSION.SDK_INT >= 24) {
            try {
                this.mMediaPlayer.setDataSource(dataSource);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setTimeout(int prepareTimeout, int readTimeout) {
    }

    @Override
    public void setSpeed(float speed) {
    }

    @Override
    public void seekTo(long msec) throws IllegalStateException {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.seekTo((int)msec);
        }
    }

    @Override
    @SuppressLint(value={"WrongConstant"})
    @RequiresApi(api=26)
    public void seekTo(long msec, boolean accurate) throws IllegalStateException {
        if (null != this.mMediaPlayer) {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mMediaPlayer.seekTo(msec, accurate ? 1 : 0);
            } else {
                this.mMediaPlayer.seekTo((int)msec);
            }
        }
    }

    @Override
    public boolean isPlaying() {
        if (null != this.mMediaPlayer) {
            return this.mMediaPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public long getCurrentPosition() {
        if (null != this.mMediaPlayer) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0L;
    }

    @Override
    public long getDuration() {
        if (null != this.mMediaPlayer) {
            return this.mMediaPlayer.getDuration();
        }
        return 0L;
    }

    @Override
    public int getBuffer() {
        return this.mBuffer;
    }

    @Override
    public void prepare() throws IOException, IllegalStateException {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.prepare();
        }
    }

    @Override
    public void prepareAsync() throws IllegalStateException {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.prepareAsync();
        }
    }

    @Override
    public void start() {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.start();
        }
    }

    @Override
    public void pause() {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.pause();
        }
    }

    @Override
    public void stop() {
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.stop();
        }
    }

    @Override
    public void reset() {
        this.mBuffer = 0;
        if (null != this.mMediaPlayer) {
            final android.media.MediaPlayer mediaPlayer = this.mMediaPlayer;
            new Thread(){

                @Override
                public void run() {
                    try {
                        mediaPlayer.reset();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    @Override
    public void release() {
        this.mBuffer = 0;
        if (null != this.mMediaPlayer) {
            this.mMediaPlayer.setOnErrorListener(null);
            this.mMediaPlayer.setOnCompletionListener(null);
            this.mMediaPlayer.setOnInfoListener(null);
            this.mMediaPlayer.setOnBufferingUpdateListener(null);
            this.mMediaPlayer.setOnPreparedListener(null);
            this.mMediaPlayer.setOnVideoSizeChangedListener(null);
            this.mMediaPlayer.setSurface(null);
            this.mMediaPlayer.setDisplay(null);
            final android.media.MediaPlayer mediaPlayer = this.mMediaPlayer;
            this.mMediaPlayer = null;
            new Thread(){

                @Override
                public void run() {
                    try {
                        mediaPlayer.release();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
        super.release();
    }

    public void onPrepared(android.media.MediaPlayer mediaPlayer) {
        if (null != this.mListener) {
            this.mListener.onPrepared(this);
        }
    }

    public void onBufferingUpdate(android.media.MediaPlayer mediaPlayer, int percent) {
        this.mBuffer = percent;
        if (null != this.mListener) {
            this.mListener.onBufferUpdate(this, percent);
        }
    }

    public void onCompletion(android.media.MediaPlayer mediaPlayer) {
        if (null != this.mListener) {
            this.mListener.onCompletion(this);
        }
    }

    public void onSeekComplete(android.media.MediaPlayer mediaPlayer) {
        if (null != this.mListener) {
            this.mListener.onSeekComplete(this);
        }
    }

    public void onVideoSizeChanged(android.media.MediaPlayer mediaPlayer, int width, int height) {
        if (null != this.mListener) {
            this.mListener.onVideoSizeChanged(this, width, height, 0, 0);
        }
    }

    public boolean onInfo(android.media.MediaPlayer mediaPlayer, int what, int extra) {
        if (null != this.mListener) {
            return this.mListener.onInfo(this, what, extra);
        }
        return true;
    }

    public boolean onError(android.media.MediaPlayer mediaPlayer, int what, int extra) {
        if (null != this.mListener) {
            return this.mListener.onError(this, what, extra);
        }
        return true;
    }
}

