/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.widget.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.android.iplayer.R;
import com.android.iplayer.base.BasePlayer;
import com.android.iplayer.listener.OnWindowActionListener;
import com.android.iplayer.utils.PlayerUtils;

public class WindowPlayerFloatView
extends FrameLayout {
    private static final String TAG = "WindowPlayerFloatView";
    private int mGroupWidth;
    private int mGroupHeight;
    private static float xDownInScreen;
    private static float yDownInScreen;
    private float xInView;
    private float yInView;
    private float translationX;
    private float translationY;
    private ViewGroup mPlayerViewGroup;
    private BasePlayer mBasePlayer;
    private int mStatusBarHeight;
    private OnWindowActionListener mWindowActionListener;

    public WindowPlayerFloatView(Context context) {
        this(context, null);
    }

    public WindowPlayerFloatView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WindowPlayerFloatView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)R.layout.player_window_float, (ViewGroup)this);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthResult = 0;
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        switch (widthSpecMode) {
            case 0: {
                widthResult = widthSpecSize;
                break;
            }
            case -2147483648: {
                widthResult = this.getContentWidth();
                break;
            }
            case 0x40000000: {
                widthResult = Math.max(this.getContentWidth(), widthSpecSize);
            }
        }
        int heightResult = 0;
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        switch (heightSpecMode) {
            case 0: {
                heightResult = heightSpecSize;
                break;
            }
            case -2147483648: {
                heightResult = this.getContentHeight();
                break;
            }
            case 0x40000000: {
                heightResult = Math.max(this.getContentHeight(), heightSpecSize);
            }
        }
        this.mGroupWidth = widthResult;
        this.mGroupHeight = heightResult;
        this.setMeasuredDimension(widthResult, heightResult);
    }

    private int getContentWidth() {
        float contentWidth = this.getWidth() + this.getPaddingLeft() + this.getPaddingRight();
        return (int)contentWidth;
    }

    private int getParentViewHeight() {
        return null != this.mPlayerViewGroup ? this.mPlayerViewGroup.getHeight() : this.getHeight();
    }

    private int getParentViewWidth() {
        return null != this.mPlayerViewGroup ? this.mPlayerViewGroup.getWidth() : this.getWidth();
    }

    private int getContentHeight() {
        float contentHeight = this.getHeight() + this.getPaddingTop() + this.getPaddingBottom();
        return (int)contentHeight;
    }

    private float getStatusBarHeight() {
        if (this.mStatusBarHeight == 0) {
            this.mStatusBarHeight = PlayerUtils.getInstance().getStatusBarHeight(this.getContext());
        }
        return this.mStatusBarHeight;
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        boolean intercepted = false;
        switch (e.getAction()) {
            case 0: {
                intercepted = false;
                this.xInView = e.getX();
                this.yInView = e.getY();
                xDownInScreen = e.getRawX();
                yDownInScreen = e.getRawY();
                if (null == this.mPlayerViewGroup) break;
                this.translationX = this.mPlayerViewGroup.getTranslationX();
                this.translationY = this.mPlayerViewGroup.getTranslationY();
                break;
            }
            case 2: {
                float absDeltaX = Math.abs(e.getRawX() - xDownInScreen);
                float absDeltaY = Math.abs(e.getRawY() - yDownInScreen);
                intercepted = absDeltaX > (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop() || absDeltaY > (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
            }
        }
        return intercepted;
    }

    public boolean onTouchEvent(MotionEvent e) {
        switch (e.getAction()) {
            case 2: {
                if (null != this.mPlayerViewGroup) {
                    float toX = this.getX() + (e.getX() - this.xInView);
                    float toY = this.getY() + (e.getY() - this.yInView);
                    if (toX <= -this.translationX) {
                        toX = -this.translationX;
                    } else if (toX >= (float)this.mGroupWidth - (this.translationX + (float)this.getParentViewWidth())) {
                        toX = (float)this.mGroupWidth - (this.translationX + (float)this.getParentViewWidth());
                    }
                    if (toY <= -this.translationY) {
                        toY = -this.translationY;
                    } else if (toY >= (float)this.mGroupHeight - (this.translationY + (float)this.getParentViewHeight())) {
                        toY = (float)this.mGroupHeight - (this.translationY + (float)this.getParentViewHeight());
                    }
                    this.setTranslationX(toX);
                    this.setTranslationY(toY);
                    break;
                }
                if (null == this.mWindowActionListener) break;
                float xInScreen = e.getRawX();
                float yInScreen = e.getRawY() - this.getStatusBarHeight();
                this.mWindowActionListener.onMovie((int)(xInScreen - this.xInView), (int)(yInScreen - this.yInView));
            }
        }
        return super.onTouchEvent(e);
    }

    public void addPlayerView(BasePlayer basePlayer, int width, int height, float startX, float startY, float radius, int bgColor) {
        if (null == basePlayer) {
            return;
        }
        this.mPlayerViewGroup = (ViewGroup)this.findViewById(R.id.player_window_group);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mPlayerViewGroup.getLayoutParams();
        layoutParams.width = width;
        layoutParams.height = height;
        this.mPlayerViewGroup.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        FrameLayout playerContainer = (FrameLayout)this.findViewById(R.id.player_window_container);
        playerContainer.addView((View)basePlayer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mPlayerViewGroup.setX(startX);
        this.mPlayerViewGroup.setY(startY);
        if (radius > 0.0f) {
            PlayerUtils.getInstance().setOutlineProvider((View)this.mPlayerViewGroup, radius);
        }
        if (bgColor != 0) {
            this.mPlayerViewGroup.setBackgroundColor(bgColor);
        }
        this.setListener(basePlayer);
    }

    public void addPlayerView(BasePlayer basePlayer, int width, int height, float radius, int bgColor) {
        if (null == basePlayer) {
            return;
        }
        FrameLayout windowGroup = (FrameLayout)this.findViewById(R.id.player_window_group);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)windowGroup.getLayoutParams();
        layoutParams.width = -1;
        layoutParams.height = -1;
        windowGroup.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        FrameLayout playerContainer = (FrameLayout)this.findViewById(R.id.player_window_container);
        playerContainer.addView((View)basePlayer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        if (radius > 0.0f) {
            PlayerUtils.getInstance().setOutlineProvider((View)playerContainer, radius);
        }
        if (bgColor != 0) {
            playerContainer.setBackgroundColor(bgColor);
        }
        this.setListener(basePlayer);
    }

    private void setListener(BasePlayer basePlayer) {
        this.findViewById(R.id.player_window_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (null != WindowPlayerFloatView.this.mWindowActionListener) {
                    WindowPlayerFloatView.this.mWindowActionListener.onClose();
                }
            }
        });
        this.mBasePlayer = basePlayer;
    }

    public void setOnWindowActionListener(OnWindowActionListener listener) {
        this.mWindowActionListener = listener;
    }

    public BasePlayer getBasePlayer() {
        return this.mBasePlayer;
    }

    public void onResume() {
        if (null != this.mBasePlayer) {
            this.mBasePlayer.onResume();
        }
    }

    public void onPause() {
        if (null != this.mBasePlayer) {
            this.mBasePlayer.onPause();
        }
    }

    public void onReset() {
        if (null != this.mBasePlayer) {
            PlayerUtils.getInstance().removeViewFromParent((View)this.mBasePlayer);
            this.mBasePlayer.onReset();
            this.mBasePlayer.onDestroy();
            this.mBasePlayer = null;
        }
        xDownInScreen = 0.0f;
        yDownInScreen = 0.0f;
        this.xInView = 0.0f;
        this.yInView = 0.0f;
        this.mStatusBarHeight = 0;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        xDownInScreen = 0.0f;
        yDownInScreen = 0.0f;
        this.xInView = 0.0f;
        this.yInView = 0.0f;
        this.translationX = 0.0f;
        this.translationY = 0.0f;
        this.mStatusBarHeight = 0;
        if (null != this.mPlayerViewGroup) {
            this.mPlayerViewGroup.removeAllViews();
        }
    }
}

