/*
 * Decompiled with CFR 0.152.
 */
package com.danikula.videocache.sourcestorage;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.danikula.videocache.Preconditions;
import com.danikula.videocache.SourceInfo;
import com.danikula.videocache.sourcestorage.SourceInfoStorage;

class DatabaseSourceInfoStorage
extends SQLiteOpenHelper
implements SourceInfoStorage {
    private static final String TABLE = "SourceInfo";
    private static final String COLUMN_ID = "_id";
    private static final String COLUMN_URL = "url";
    private static final String COLUMN_LENGTH = "length";
    private static final String COLUMN_MIME = "mime";
    private static final String[] ALL_COLUMNS = new String[]{"_id", "url", "length", "mime"};
    private static final String CREATE_SQL = "CREATE TABLE SourceInfo (_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,url TEXT NOT NULL,mime TEXT,length INTEGER);";

    DatabaseSourceInfoStorage(Context context) {
        super(context, "AndroidVideoCache.db", null, 1);
        Preconditions.checkNotNull(context);
    }

    public void onCreate(SQLiteDatabase db) {
        Preconditions.checkNotNull(db);
        db.execSQL(CREATE_SQL);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        throw new IllegalStateException("Should not be called. There is no any migration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceInfo get(String url) {
        Preconditions.checkNotNull(url);
        try (Cursor cursor = null;){
            cursor = this.getReadableDatabase().query(TABLE, ALL_COLUMNS, "url=?", new String[]{url}, null, null, null);
            SourceInfo sourceInfo = cursor == null || !cursor.moveToFirst() ? null : this.convert(cursor);
            return sourceInfo;
        }
    }

    @Override
    public void put(String url, SourceInfo sourceInfo) {
        Preconditions.checkAllNotNull(url, sourceInfo);
        SourceInfo sourceInfoFromDb = this.get(url);
        boolean exist = sourceInfoFromDb != null;
        ContentValues contentValues = this.convert(sourceInfo);
        if (exist) {
            this.getWritableDatabase().update(TABLE, contentValues, "url=?", new String[]{url});
        } else {
            this.getWritableDatabase().insert(TABLE, null, contentValues);
        }
    }

    @Override
    public void release() {
        this.close();
    }

    private SourceInfo convert(Cursor cursor) {
        return new SourceInfo(cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_URL)), cursor.getLong(cursor.getColumnIndexOrThrow(COLUMN_LENGTH)), cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_MIME)));
    }

    private ContentValues convert(SourceInfo sourceInfo) {
        ContentValues values = new ContentValues();
        values.put(COLUMN_URL, sourceInfo.url);
        values.put(COLUMN_LENGTH, Long.valueOf(sourceInfo.length));
        values.put(COLUMN_MIME, sourceInfo.mime);
        return values;
    }
}

