/*
 * Decompiled with CFR 0.152.
 */
package com.android.iplayer.video.cache.task;

import android.util.Log;
import com.android.iplayer.video.cache.VideoCache;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class PreloadTask
implements Runnable {
    private static final String TAG = "PreloadTask";
    private String mRawUrl;
    private int mPosition = -1;
    private boolean mIsCanceled;
    private boolean mIsExecuted;
    private int mPreloadLength = 0x100000;
    private static final List<String> sBlackList = new ArrayList<String>();

    private PreloadTask() {
    }

    public PreloadTask(String rawUrl) {
        this(rawUrl, -1);
    }

    public PreloadTask(String rawUrl, int position) {
        this.mRawUrl = rawUrl;
        this.mPosition = position;
    }

    public PreloadTask(String rawUrl, int position, int preloadLength) {
        this.mRawUrl = rawUrl;
        this.mPosition = position;
        this.mPreloadLength = preloadLength;
    }

    @Override
    public void run() {
        if (!this.mIsCanceled) {
            this.start();
        }
        this.mIsExecuted = false;
        this.mIsCanceled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        if (sBlackList.contains(this.mRawUrl)) {
            return;
        }
        HttpURLConnection connection = null;
        try {
            int length;
            String proxyUrl = VideoCache.getInstance().getProxy().getProxyUrl(this.mRawUrl);
            URL url = new URL(proxyUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            int read = -1;
            byte[] bytes = new byte[8192];
            while ((length = ((InputStream)in).read(bytes)) != -1) {
                if (!this.mIsCanceled && (read += length) < this.mPreloadLength) continue;
                if (this.mIsCanceled) {
                    Log.d((String)TAG, (String)("\u9884\u7f13\u5b58\u53d6\u6d88:position:" + this.mPosition + ",Byte:" + read));
                } else {
                    Log.d((String)TAG, (String)("\u9884\u7f13\u5b58\u6210\u529f:position:" + this.mPosition + ",Byte:" + read));
                }
                break;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)("\u9884\u7f13\u5b58\u5f02\u5e38:position:" + this.mPosition + ",error:" + e.getMessage()));
            sBlackList.add(this.mRawUrl);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
            Log.d((String)TAG, (String)("\u9884\u7f13\u5b58\u7ed3\u675f:position:" + this.mPosition));
        }
    }

    public void executeOn(ExecutorService executorService) {
        if (this.mIsExecuted) {
            return;
        }
        this.mIsExecuted = true;
        executorService.submit(this);
    }

    public String getRawUrl() {
        return this.mRawUrl;
    }

    public int getPosition() {
        return this.mPosition;
    }

    public void cancel() {
        if (this.mIsExecuted) {
            this.mIsCanceled = true;
        }
    }
}

