/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.image.config;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.hss01248.image.MyUtil;
import com.hss01248.image.R;
import com.hss01248.image.config.GlobalConfig;
import java.io.File;

public class SingleConfig {
    private Context context;
    private boolean isUseARGB8888;
    private boolean ignoreCertificateVerify;
    private String url;
    private String thumbnailUrl;
    private String filePath;
    private int resId;
    private String contentProvider;
    private boolean isGif;
    private View target;
    private int width;
    private int height;
    private boolean needBlur;
    private int blurRadius;
    private int placeHolderResId;
    private boolean reuseable;
    private int placeHolderScaleType;
    private int errorScaleType;
    private int loadingScaleType;
    private int loadingResId;
    private int errorResId;
    private int shapeMode;
    private int rectRoundRadius;
    private int roundOverlayColor;
    private int scaleMode;
    private int borderWidth;
    private int borderColor;
    private boolean asBitmap;
    private BitmapListener bitmapListener;
    private boolean cropFace;

    public Context getContext() {
        if (this.context == null) {
            this.context = GlobalConfig.context;
        }
        return this.context;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public String getContentProvider() {
        return this.contentProvider;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getHeight() {
        if (this.height <= 0 && this.target != null) {
            this.height = this.target.getMeasuredHeight();
        }
        return this.height;
    }

    public boolean isUseARGB8888() {
        return this.isUseARGB8888;
    }

    public boolean isNeedBlur() {
        return this.needBlur;
    }

    public int getPlaceHolderResId() {
        return this.placeHolderResId;
    }

    public int getRectRoundRadius() {
        return this.rectRoundRadius;
    }

    public int getResId() {
        return this.resId;
    }

    public int getScaleMode() {
        return this.scaleMode;
    }

    public int getShapeMode() {
        return this.shapeMode;
    }

    public View getTarget() {
        return this.target;
    }

    public String getUrl() {
        return this.url;
    }

    public int getWidth() {
        if (this.width <= 0 && this.target != null) {
            this.width = this.target.getMeasuredWidth();
        }
        return this.width;
    }

    public int getRoundOverlayColor() {
        return this.roundOverlayColor;
    }

    public boolean isIgnoreCertificateVerify() {
        return this.ignoreCertificateVerify;
    }

    public BitmapListener getBitmapListener() {
        return this.bitmapListener;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public int getPlaceHolderScaleType() {
        return this.placeHolderScaleType;
    }

    public int getErrorScaleType() {
        return this.errorScaleType;
    }

    public int getLoadingResId() {
        return this.loadingResId;
    }

    public int getErrorResId() {
        return this.errorResId;
    }

    public boolean isReuseable() {
        return this.reuseable;
    }

    public void setAsBitmap(boolean asBitmap) {
        this.asBitmap = asBitmap;
    }

    public boolean isAsBitmap() {
        return this.asBitmap;
    }

    public void setBitmapListener(BitmapListener bitmapListener) {
        this.bitmapListener = MyUtil.getBitmapListenerProxy(bitmapListener);
    }

    public boolean isCropFace() {
        return this.cropFace;
    }

    private void show() {
        GlobalConfig.getLoader().request(this);
    }

    public boolean isGif() {
        return this.isGif;
    }

    public int getBlurRadius() {
        return this.blurRadius;
    }

    public int getLoadingScaleType() {
        return this.loadingScaleType;
    }

    public SingleConfig(ConfigBuilder builder) {
        this.url = builder.url;
        this.thumbnailUrl = builder.thumbnailUrl;
        this.filePath = builder.filePath;
        this.resId = builder.resId;
        this.contentProvider = builder.contentProvider;
        this.ignoreCertificateVerify = builder.ignoreCertificateVerify;
        this.target = builder.target;
        this.setWH(builder);
        this.shapeMode = builder.shapeMode;
        if (this.shapeMode == 1) {
            this.rectRoundRadius = builder.rectRoundRadius;
        }
        this.scaleMode = builder.scaleMode;
        this.needBlur = builder.needBlur;
        this.placeHolderResId = builder.placeHolderResId;
        this.borderWidth = builder.borderWidth;
        if (this.borderWidth > 0) {
            this.borderColor = builder.borderColor;
        }
        this.asBitmap = builder.asBitmap;
        this.bitmapListener = builder.bitmapListener;
        this.roundOverlayColor = builder.roundOverlayColor;
        this.isGif = builder.isGif;
        this.blurRadius = builder.blurRadius;
        this.reuseable = builder.reuseable;
        this.loadingResId = builder.loadingResId;
        this.errorResId = builder.errorResId;
        this.cropFace = builder.cropFace;
        this.errorScaleType = builder.errorScaleType;
        this.placeHolderScaleType = builder.placeHolderScaleType;
        this.loadingScaleType = builder.loadingScaleType;
        this.isUseARGB8888 = builder.isUseARGB8888;
    }

    private void setWH(ConfigBuilder builder) {
        if (!builder.asBitmap) {
            ViewGroup.LayoutParams params;
            View view = builder.target;
            if (view != null && (params = view.getLayoutParams()) != null) {
                int h = params.height;
                int w = params.width;
                if (w > 0 && builder.width <= 0) {
                    this.width = w;
                }
                if (h > 0 && builder.height <= 0) {
                    this.height = h;
                }
            }
        } else {
            this.width = builder.width;
            this.height = builder.height;
        }
    }

    public static class ConfigBuilder {
        private Context context;
        private boolean ignoreCertificateVerify = GlobalConfig.ignoreCertificateVerify;
        private String url;
        private String thumbnailUrl;
        private String filePath;
        private int resId;
        private String contentProvider;
        private boolean isGif = false;
        private View target;
        private boolean asBitmap;
        private BitmapListener bitmapListener;
        private int width;
        private int height;
        private boolean needBlur = false;
        private int blurRadius;
        private int loadingScaleType = GlobalConfig.loadingScaleType;
        private int placeHolderResId = GlobalConfig.placeHolderResId;
        private boolean reuseable;
        private boolean isUseARGB8888;
        private int placeHolderScaleType = GlobalConfig.placeHolderScaleType;
        private int errorScaleType = GlobalConfig.errorScaleType;
        private int loadingResId = GlobalConfig.loadingResId;
        private int errorResId = GlobalConfig.errorResId;
        private int shapeMode;
        private int rectRoundRadius;
        private int roundOverlayColor;
        private int scaleMode;
        private int borderWidth;
        private int borderColor;
        private boolean cropFace;

        public ConfigBuilder setLoadingScaleType(int loadingScaleType) {
            this.loadingScaleType = loadingScaleType;
            return this;
        }

        public ConfigBuilder setUseARGB8888(boolean useARGB8888) {
            this.isUseARGB8888 = useARGB8888;
            return this;
        }

        public ConfigBuilder setRoundOverlayColor(int roundOverlayColor) {
            this.roundOverlayColor = roundOverlayColor;
            return this;
        }

        public ConfigBuilder(Context context) {
            this.context = context;
        }

        public ConfigBuilder ignoreCertificateVerify(boolean ignoreCertificateVerify) {
            this.ignoreCertificateVerify = ignoreCertificateVerify;
            return this;
        }

        public ConfigBuilder url(String url) {
            this.url = url;
            if (url.contains("gif")) {
                this.isGif = true;
            }
            return this;
        }

        public ConfigBuilder thumbnail(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this;
        }

        public ConfigBuilder loading(int loadingResId) {
            this.loadingResId = loadingResId;
            return this;
        }

        public ConfigBuilder loadingDefault() {
            this.loadingResId = R.drawable.imageloader_loading_50;
            return this;
        }

        public ConfigBuilder loading(int loadingResId, int loadingScaleType) {
            this.loadingResId = loadingResId;
            this.loadingScaleType = loadingScaleType;
            return this;
        }

        public ConfigBuilder error(int errorResId) {
            this.errorResId = errorResId;
            return this;
        }

        public ConfigBuilder error(int errorResId, int errorScaleType) {
            this.errorResId = errorResId;
            this.errorScaleType = errorScaleType;
            return this;
        }

        public ConfigBuilder cropFace() {
            this.cropFace = true;
            return this;
        }

        public ConfigBuilder file(String filePath) {
            if (filePath.startsWith("content:")) {
                this.contentProvider = filePath;
                return this;
            }
            if (!new File(filePath).exists()) {
                Log.e((String)"imageloader", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
                return this;
            }
            this.filePath = filePath;
            if (filePath.contains("gif")) {
                this.isGif = true;
            }
            return this;
        }

        public ConfigBuilder res(int resId) {
            this.resId = resId;
            return this;
        }

        public ConfigBuilder content(String contentProvider) {
            this.contentProvider = contentProvider;
            return this;
        }

        public void into(View targetView) {
            this.target = targetView;
            new SingleConfig(this).show();
        }

        public ConfigBuilder listener(BitmapListener bitmapListener) {
            this.bitmapListener = MyUtil.getBitmapListenerProxy(bitmapListener);
            return this;
        }

        public void asBitmap(BitmapListener bitmapListener) {
            this.bitmapListener = MyUtil.getBitmapListenerProxy(bitmapListener);
            this.asBitmap = true;
            new SingleConfig(this).show();
        }

        public ConfigBuilder widthHeight(int widthInDp, int heightInDp) {
            this.width = MyUtil.dip2px(widthInDp);
            this.height = MyUtil.dip2px(heightInDp);
            return this;
        }

        public ConfigBuilder widthHeightByPx(int widthInPx, int heightInPx) {
            this.width = widthInPx;
            this.height = heightInPx;
            return this;
        }

        public ConfigBuilder placeHolder(int placeHolderResId, boolean reuseable, int placeHolderScaleType) {
            this.placeHolderResId = placeHolderResId;
            this.reuseable = reuseable;
            this.placeHolderScaleType = placeHolderScaleType;
            return this;
        }

        public ConfigBuilder placeHolder(int placeHolderResId, boolean reuseable) {
            this.placeHolderResId = placeHolderResId;
            this.reuseable = reuseable;
            return this;
        }

        public ConfigBuilder placeHolder(int placeHolderResId) {
            this.placeHolderResId = placeHolderResId;
            this.reuseable = true;
            return this;
        }

        public ConfigBuilder blur(int blurRadius) {
            this.needBlur = true;
            this.blurRadius = blurRadius;
            return this;
        }

        public ConfigBuilder asCircle(int overlayColorWhenGif) {
            this.shapeMode = 2;
            this.roundOverlayColor = overlayColorWhenGif;
            return this;
        }

        public ConfigBuilder rectRoundCorner(int rectRoundRadius, int overlayColorWhenGif) {
            this.rectRoundRadius = MyUtil.dip2px(rectRoundRadius);
            this.shapeMode = 1;
            this.roundOverlayColor = overlayColorWhenGif;
            return this;
        }

        public ConfigBuilder scale(int scaleMode) {
            this.scaleMode = scaleMode;
            return this;
        }

        public ConfigBuilder border(int borderWidth, int borderColor) {
            this.borderWidth = MyUtil.dip2px(borderWidth);
            this.borderColor = borderColor;
            return this;
        }

        public String toString() {
            return "{context:" + this.context + ", ignoreCertificateVerify:" + this.ignoreCertificateVerify + ", url:'" + this.url + '\'' + ", thumbnailUrl:'" + this.thumbnailUrl + '\'' + ", filePath:'" + this.filePath + '\'' + ", resId=" + this.resId + ", contentProvider:'" + this.contentProvider + '\'' + ", isGif:" + this.isGif + ", target:" + this.target + ", asBitmap:" + this.asBitmap + ", bitmapListener:" + this.bitmapListener + ", width:" + this.width + ", height:" + this.height + ", needBlur:" + this.needBlur + ", blurRadius:" + this.blurRadius + ", loadingScaleType:" + this.loadingScaleType + ", placeHolderResId:" + this.placeHolderResId + ", reuseable:" + this.reuseable + ", placeHolderScaleType:" + this.placeHolderScaleType + ", errorScaleType:" + this.errorScaleType + ", loadingResId:" + this.loadingResId + ", errorResId:" + this.errorResId + ", shapeMode:" + this.shapeMode + ", rectRoundRadius:" + this.rectRoundRadius + ", roundOverlayColor:" + this.roundOverlayColor + ", scaleMode:" + this.scaleMode + ", borderWidth:" + this.borderWidth + ", borderColor:" + this.borderColor + ", cropFace:" + this.cropFace + '}';
        }
    }

    public static interface BitmapListener {
        public void onSuccess(Bitmap var1);

        public void onFail(Throwable var1);
    }
}

