/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.image.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolProxy {
    ThreadPoolExecutor mExecutor;
    int mCorePoolSize;
    int mMaximumPoolSize;
    long mKeepAliveTime;

    public ThreadPoolProxy(int corePoolSize, int maximumPoolSize, long keepAliveTime) {
        this.mCorePoolSize = corePoolSize;
        this.mMaximumPoolSize = maximumPoolSize;
        this.mKeepAliveTime = keepAliveTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ThreadPoolExecutor initThreadPoolExecutor() {
        if (this.mExecutor != null) return this.mExecutor;
        Class<ThreadPoolProxy> clazz = ThreadPoolProxy.class;
        synchronized (ThreadPoolProxy.class) {
            if (this.mExecutor != null) return this.mExecutor;
            TimeUnit unit = TimeUnit.MILLISECONDS;
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
            ThreadFactory threadFactory = Executors.defaultThreadFactory();
            ThreadPoolExecutor.AbortPolicy handler = new ThreadPoolExecutor.AbortPolicy();
            this.mExecutor = new ThreadPoolExecutor(this.mCorePoolSize, this.mMaximumPoolSize, this.mKeepAliveTime, unit, workQueue, threadFactory, handler);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mExecutor;
        }
    }

    public void execute(Runnable task) {
        this.initThreadPoolExecutor();
        this.mExecutor.execute(task);
    }

    public Future<?> submit(Runnable task) {
        this.initThreadPoolExecutor();
        return this.mExecutor.submit(task);
    }

    public void removeTask(Runnable task) {
        this.initThreadPoolExecutor();
        this.mExecutor.remove(task);
    }
}

