/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.view;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.TypedArray;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.widget.FrameLayout;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.github.piasy.biv.BigImageViewer;
import com.github.piasy.biv.event.CacheHitEvent;
import com.github.piasy.biv.event.CacheHitEvent2;
import com.github.piasy.biv.event.ErrorEvent;
import com.github.piasy.biv.event.ProgressEvent;
import com.github.piasy.biv.indicator.ProgressIndicator;
import com.github.piasy.biv.indicator.ProgressPieIndicator;
import com.github.piasy.biv.loader.BigLoader;
import com.github.piasy.biv.view.BigImageHierarchy;
import com.github.piasy.biv.view.DisplayOptimizeListener;
import com.github.piasy.biv.view.ImageSaveCallback;
import com.github.piasy.biv.view.ProgressNotifyRunnable;
import com.hss01248.image.R;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class BigImageView
extends FrameLayout
implements BigImageHierarchy {
    public static final int INIT_SCALE_TYPE_CENTER_INSIDE = 1;
    public static final int INIT_SCALE_TYPE_CENTER_CROP = 2;
    public static final int INIT_SCALE_TYPE_AUTO = 3;
    private final SubsamplingScaleImageView mImageView;
    private View progressView;
    private View errorView;
    private View mThumbnailView;
    private View placeHolder;
    private final BigLoader mImageLoader;
    private Map<String, File> mTempImages;
    private ImageSaveCallback mImageSaveCallback;
    private File mCurrentImageFile;
    private Uri mThumbnail;
    private ProgressIndicator mProgressIndicator;
    private final ProgressNotifyRunnable mProgressNotifyRunnable = new ProgressNotifyRunnable(){

        @Override
        public void run() {
            if (BigImageView.this.mProgressIndicator != null) {
                BigImageView.this.mProgressIndicator.onProgress(this.mProgress);
                this.notified();
            }
        }
    };
    private DisplayOptimizeListener mDisplayOptimizeListener;
    private int mInitScaleType;
    private boolean mOptimizeDisplay;
    int currentState;
    public static final int STATE_NONE = 0;
    public static final int STATE_STATRTED = 1;
    public static final int STATE_PROGRESSING = 2;
    public static final int STATE_CONTENT = 3;
    public static final int STATE_ERROR = 4;
    private String url;

    public void updateHierachy() {
    }

    public BigImageView(Context context) {
        this(context, null);
    }

    public BigImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BigImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BigImageView, defStyleAttr, 0);
        this.mInitScaleType = array.getInteger(R.styleable.BigImageView_initScaleType, 1);
        this.mOptimizeDisplay = array.getBoolean(R.styleable.BigImageView_optimizeDisplay, true);
        array.recycle();
        this.mImageView = new SubsamplingScaleImageView(context, attrs);
        this.addView((View)this.mImageView);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.mImageView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mImageView.setMinimumTileDpi(160);
        this.errorView = View.inflate((Context)context, (int)R.layout.error_view, null);
        FrameLayout.LayoutParams params2 = new FrameLayout.LayoutParams(-1, -1);
        this.errorView.setLayoutParams((ViewGroup.LayoutParams)params2);
        this.addView(this.errorView);
        this.placeHolder = View.inflate((Context)context, (int)R.layout.view_placeholder, null);
        FrameLayout.LayoutParams params3 = new FrameLayout.LayoutParams(-1, -1);
        this.placeHolder.setLayoutParams((ViewGroup.LayoutParams)params3);
        this.addView(this.placeHolder);
        this.setProgressIndicator(new ProgressPieIndicator());
        this.setOptimizeDisplay(this.mOptimizeDisplay);
        this.setInitScaleType(this.mInitScaleType);
        this.mImageLoader = BigImageViewer.imageLoader();
        this.mTempImages = new HashMap<String, File>();
    }

    public void setCachedFileMap(Map<String, File> cachedFileMap) {
        this.mTempImages = cachedFileMap;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.mImageView.setOnClickListener(listener);
    }

    public void setOnLongClickListener(View.OnLongClickListener listener) {
        this.mImageView.setOnLongClickListener(listener);
    }

    public void setInitScaleType(int initScaleType) {
        this.mInitScaleType = initScaleType;
        switch (initScaleType) {
            case 2: {
                this.mImageView.setMinimumScaleType(2);
                break;
            }
            case 3: {
                this.mImageView.setMinimumScaleType(3);
                break;
            }
            default: {
                this.mImageView.setMinimumScaleType(1);
            }
        }
        if (this.mDisplayOptimizeListener != null) {
            this.mDisplayOptimizeListener.setInitScaleType(initScaleType);
        }
    }

    public void setOptimizeDisplay(boolean optimizeDisplay) {
        this.mOptimizeDisplay = optimizeDisplay;
        if (this.mOptimizeDisplay) {
            this.mDisplayOptimizeListener = new DisplayOptimizeListener(this.mImageView);
            this.mImageView.setOnImageEventListener((SubsamplingScaleImageView.OnImageEventListener)this.mDisplayOptimizeListener);
        } else {
            this.mDisplayOptimizeListener = null;
            this.mImageView.setOnImageEventListener(null);
        }
    }

    public void setImageSaveCallback(ImageSaveCallback imageSaveCallback) {
        this.mImageSaveCallback = imageSaveCallback;
    }

    public void setErrorView(View error) {
        if (error != null && this.errorView == null) {
            this.errorView = error;
            this.addView(this.errorView);
        }
    }

    public void setProgressIndicator(ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            this.mProgressIndicator = null;
            if (this.progressView != null) {
                this.removeView(this.progressView);
            }
        }
        if (progressIndicator.equals(this.mProgressIndicator)) {
            return;
        }
        if (this.mProgressIndicator == null) {
            this.mProgressIndicator = progressIndicator;
            this.progressView = this.mProgressIndicator.getView(this);
            if (this.progressView.getParent() != null) {
                ViewGroup viewGroup = (ViewGroup)this.progressView.getParent();
                viewGroup.removeView(this.progressView);
            }
            this.addView(this.progressView);
        }
    }

    public String currentImageFile() {
        return this.mCurrentImageFile == null ? "" : this.mCurrentImageFile.getAbsolutePath();
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public void saveImageIntoGallery() {
        block7: {
            if (this.mCurrentImageFile == null) {
                if (this.mImageSaveCallback != null) {
                    this.mImageSaveCallback.onFail(new IllegalStateException("image not downloaded yet"));
                }
                return;
            }
            try {
                String result = MediaStore.Images.Media.insertImage((ContentResolver)this.getContext().getContentResolver(), (String)this.mCurrentImageFile.getAbsolutePath(), (String)this.mCurrentImageFile.getName(), (String)"");
                if (this.mImageSaveCallback != null) {
                    if (!TextUtils.isEmpty((CharSequence)result)) {
                        this.mImageSaveCallback.onSuccess(result);
                    } else {
                        this.mImageSaveCallback.onFail(new RuntimeException("saveImageIntoGallery fail"));
                    }
                }
            }
            catch (FileNotFoundException e) {
                if (this.mImageSaveCallback == null) break block7;
                this.mImageSaveCallback.onFail(e);
            }
        }
    }

    public void showImage(Uri uri) {
        this.showImage(Uri.EMPTY, uri);
    }

    public void showImage(Uri thumbnail, Uri uri) {
        this.url = uri.toString();
        this.mThumbnail = thumbnail;
        if (this.url.startsWith("file:///")) {
            this.onStart();
            this.showContent(new File(this.url.substring(8)));
            return;
        }
        if (this.mTempImages.containsKey(this.url)) {
            Log.e((String)"dd", (String)"mTempImages.containsKey(this.url),show content");
            this.showContent(this.mTempImages.get(this.url));
        } else {
            this.onStart();
            this.mImageLoader.loadImage(uri);
        }
    }

    private void doOnFinish() {
        if (this.mOptimizeDisplay) {
            AnimationSet set = new AnimationSet(true);
            AlphaAnimation animation = new AlphaAnimation(1.0f, 0.0f);
            animation.setDuration(500L);
            animation.setFillAfter(true);
            set.addAnimation((Animation)animation);
            if (this.mThumbnailView != null) {
                this.mThumbnailView.setAnimation((Animation)set);
            }
            if (this.mProgressIndicator != null) {
                this.mProgressIndicator.onFinish();
            }
            if (this.progressView != null) {
                this.progressView.setAnimation((Animation)set);
            }
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (BigImageView.this.mThumbnailView != null) {
                        BigImageView.this.mThumbnailView.setVisibility(8);
                    }
                    if (BigImageView.this.progressView != null) {
                        BigImageView.this.progressView.setVisibility(8);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        } else {
            if (this.mProgressIndicator != null) {
                this.mProgressIndicator.onFinish();
            }
            if (this.mThumbnailView != null) {
                this.mThumbnailView.setVisibility(8);
            }
            if (this.progressView != null) {
                this.progressView.setVisibility(8);
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register((Object)this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister((Object)this);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onProgressEvent(ProgressEvent event) {
        if (this.url.equals(event.url)) {
            this.showProgress(event.progress);
            if (event.progress == 100) {
                // empty if block
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onErrorEvent(ErrorEvent event) {
        Log.d((String)"BigImageView", (String)("onFailEvent---event url: " + event.url));
        Log.d((String)"BigImageView", (String)("onFailEvent---old url: " + this.url));
        if (this.url.equals(event.url)) {
            this.showError();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onCacheHitEvent(CacheHitEvent event) {
        Log.d((String)"BigImageView", (String)("onCacheHitEvent---event url: " + event.url));
        Log.d((String)"BigImageView", (String)("onCacheHitEvent---old url: " + this.url));
        if (this.url.equals(event.url) && event.file != null && event.file.exists() && event.file.length() > 100L) {
            this.mCurrentImageFile = event.file;
            this.mTempImages.put(this.url, event.file);
            this.showContent(event.file);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onCacheHitEvent(CacheHitEvent2 event) {
        Log.d((String)"BigImageView", (String)("onCacheHitEvent2---event url: " + event.url));
        Log.d((String)"BigImageView", (String)("onCacheHitEvent2---old url: " + this.url));
        if (this.url.equals(event.url)) {
            this.mImageView.setImage(ImageSource.uri((Uri)event.uri));
            this.showContent(null);
        }
    }

    @Override
    public void showContent(File image) {
        this.mImageView.setVisibility(0);
        if (image != null) {
            this.mImageView.setImage(ImageSource.uri((Uri)Uri.fromFile((File)image)));
        }
        Log.d((String)"BigImageView", (String)("mImageView.setImage: " + image.getAbsolutePath()));
        this.currentState = 3;
        if (this.progressView != null) {
            this.progressView.setVisibility(8);
        }
        if (this.mThumbnailView != null) {
            this.mThumbnailView.setVisibility(8);
        }
        if (this.errorView != null) {
            this.errorView.setVisibility(8);
        }
        if (this.placeHolder != null) {
            this.placeHolder.setVisibility(8);
        }
    }

    @Override
    public void showProgress(int progress) {
        if (this.currentState != 2) {
            this.currentState = 2;
            this.mImageView.setVisibility(8);
            if (this.progressView != null) {
                this.progressView.setVisibility(0);
            }
            if (this.mThumbnailView != null) {
                this.mThumbnailView.setVisibility(8);
            }
            if (this.errorView != null) {
                this.errorView.setVisibility(8);
            }
            if (this.placeHolder != null) {
                this.placeHolder.setVisibility(8);
            }
        }
        this.mProgressIndicator.onProgress(progress);
    }

    @Override
    public void showError() {
        this.currentState = 4;
        this.mImageView.setVisibility(8);
        if (this.progressView != null) {
            this.progressView.setVisibility(8);
        }
        if (this.mThumbnailView != null) {
            this.mThumbnailView.setVisibility(8);
        }
        if (this.errorView != null) {
            this.errorView.setVisibility(0);
        }
        if (this.placeHolder != null) {
            this.placeHolder.setVisibility(8);
        }
    }

    @Override
    public void showThumbnail() {
        this.currentState = 1;
        this.mImageView.setVisibility(8);
        if (this.progressView != null) {
            this.progressView.setVisibility(8);
        }
        if (this.mThumbnailView != null) {
            this.mThumbnailView.setVisibility(0);
        }
        if (this.errorView != null) {
            this.errorView.setVisibility(8);
        }
        if (this.placeHolder != null) {
            this.placeHolder.setVisibility(8);
        }
    }

    @Override
    public void onStart() {
        this.currentState = 1;
        this.mImageView.setVisibility(8);
        if (this.progressView != null) {
            this.progressView.setVisibility(8);
        }
        if (this.mThumbnailView != null) {
            this.mThumbnailView.setVisibility(8);
        }
        if (this.errorView != null) {
            this.errorView.setVisibility(8);
        }
        if (this.placeHolder != null) {
            this.placeHolder.setVisibility(0);
        }
    }
}

