/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.progress;

import com.github.piasy.biv.event.ProgressEvent;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.greenrobot.eventbus.EventBus;

public class OkHttpProgressResponseBody
extends ResponseBody {
    private final String mUrl;
    private final ResponseBody mResponseBody;
    private BufferedSource mBufferedSource;

    public OkHttpProgressResponseBody(String url, ResponseBody responseBody) {
        this.mUrl = url;
        this.mResponseBody = responseBody;
    }

    public MediaType contentType() {
        return this.mResponseBody.contentType();
    }

    public long contentLength() {
        return this.mResponseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.mBufferedSource == null) {
            this.mBufferedSource = Okio.buffer((Source)this.source((Source)this.mResponseBody.source()));
        }
        return this.mBufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            private long mTotalBytesRead;
            {
                this.mTotalBytesRead = 0L;
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                long fullLength = OkHttpProgressResponseBody.this.mResponseBody.contentLength();
                if (this.mTotalBytesRead == 0L) {
                    // empty if block
                }
                this.mTotalBytesRead = bytesRead == -1L ? fullLength : (this.mTotalBytesRead += bytesRead);
                EventBus.getDefault().post((Object)new ProgressEvent((int)(this.mTotalBytesRead * 100L / fullLength), this.mTotalBytesRead == fullLength, OkHttpProgressResponseBody.this.mUrl));
                return bytesRead;
            }
        };
    }
}

