/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.image;

import android.content.Context;
import android.net.Uri;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.github.piasy.biv.BigImageViewer;
import com.hss01248.image.bigimage.MyRecyclePagerAdapter;
import com.hss01248.image.bigimage.RecycleAdapterForBigImage;
import com.hss01248.image.config.GlobalConfig;
import com.hss01248.image.config.SingleConfig;
import com.hss01248.image.interfaces.ILoader;
import java.io.File;
import java.util.List;

public class ImageLoader {
    public static Context context;

    public static void init(Context context, int cacheSizeInM, ILoader imageLoader) {
        ImageLoader.context = context;
        GlobalConfig.init(context, cacheSizeInM, imageLoader);
    }

    public static ILoader getActualLoader() {
        return GlobalConfig.getLoader();
    }

    public static SingleConfig.ConfigBuilder with(Context context) {
        return new SingleConfig.ConfigBuilder(context);
    }

    public static void loadBigImage(View imageView, String path) {
        if (path.startsWith("content:")) {
            new SingleConfig.ConfigBuilder(context).content(path).into(imageView);
        } else if (path.startsWith("http")) {
            new SingleConfig.ConfigBuilder(context).url(path).into(imageView);
        } else {
            new SingleConfig.ConfigBuilder(context).file(path).into(imageView);
        }
    }

    public static void loadBigImages(ViewPager viewPager, List<String> urls) {
        viewPager.setOffscreenPageLimit(1);
        if (viewPager.getAdapter() == null) {
            MyRecyclePagerAdapter adapter = new MyRecyclePagerAdapter(urls);
            viewPager.setAdapter((PagerAdapter)adapter);
        } else if (viewPager.getAdapter() instanceof MyRecyclePagerAdapter) {
            MyRecyclePagerAdapter adapterForBigImage = (MyRecyclePagerAdapter)viewPager.getAdapter();
            adapterForBigImage.changeDatas(urls);
        } else {
            throw new RuntimeException("\u7528\u4e8e\u52a0\u8f7d\u5927\u56fe\u7684viewPager\u5e94\u8be5\u4e13\u7528,\u5176adapter\u4e0d\u8981\u81ea\u5df1\u8bbe\u7f6e");
        }
    }

    public static void loadBigImages(RecyclerView recyclerView, List<String> urls) {
        recyclerView.setAdapter((RecyclerView.Adapter)new RecycleAdapterForBigImage(urls));
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(recyclerView.getContext(), 0, false));
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
    }

    private static void saveImageIntoGallery(String url) {
        File file = GlobalConfig.getLoader().getFileFromDiskCache(url);
        if (file == null || file.exists()) {
            // empty if block
        }
    }

    public static void prefech(String ... urls) {
        Uri[] uris = new Uri[urls.length];
        for (int i = 0; i < uris.length; ++i) {
            uris[i] = Uri.parse((String)urls[i]);
        }
        BigImageViewer.prefetch(uris);
    }

    public static void trimMemory(int level) {
        GlobalConfig.getLoader().trimMemory(level);
    }

    public static void clearAllMemoryCaches() {
        GlobalConfig.getLoader().clearAllMemoryCaches();
    }
}

