/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.view;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.TypedArray;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.annotation.RequiresPermission;
import android.support.annotation.UiThread;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.widget.FrameLayout;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.github.piasy.biv.BigImageViewer;
import com.github.piasy.biv.event.CacheHitEvent;
import com.github.piasy.biv.event.ErrorEvent;
import com.github.piasy.biv.event.NoCacheEvent;
import com.github.piasy.biv.event.ProgressEvent;
import com.github.piasy.biv.event.StartEvent;
import com.github.piasy.biv.indicator.ProgressIndicator;
import com.github.piasy.biv.loader.ImageLoader;
import com.github.piasy.biv.view.DisplayOptimizeListener;
import com.github.piasy.biv.view.ImageSaveCallback;
import com.github.piasy.biv.view.ProgressNotifyRunnable;
import com.hss01248.image.R;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class BigImageView
extends FrameLayout {
    public static final int INIT_SCALE_TYPE_CENTER_INSIDE = 1;
    public static final int INIT_SCALE_TYPE_CENTER_CROP = 2;
    public static final int INIT_SCALE_TYPE_AUTO = 3;
    private final SubsamplingScaleImageView mImageView;
    private final ImageLoader mImageLoader;
    private final List<File> mTempImages;
    private View mProgressIndicatorView;
    private View mThumbnailView;
    private ImageSaveCallback mImageSaveCallback;
    private File mCurrentImageFile;
    private Uri mThumbnail;
    private ProgressIndicator mProgressIndicator;
    private final ProgressNotifyRunnable mProgressNotifyRunnable = new ProgressNotifyRunnable(){

        @Override
        public void run() {
            if (BigImageView.this.mProgressIndicator != null) {
                BigImageView.this.mProgressIndicator.onProgress(this.mProgress);
                this.notified();
            }
        }
    };
    private DisplayOptimizeListener mDisplayOptimizeListener;
    private int mInitScaleType;
    private boolean mOptimizeDisplay;
    private String url;

    public BigImageView(Context context) {
        this(context, null);
    }

    public BigImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BigImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BigImageView, defStyleAttr, 0);
        this.mInitScaleType = array.getInteger(R.styleable.BigImageView_initScaleType, 1);
        this.mOptimizeDisplay = array.getBoolean(R.styleable.BigImageView_optimizeDisplay, true);
        array.recycle();
        this.mImageView = new SubsamplingScaleImageView(context, attrs);
        this.addView((View)this.mImageView);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.mImageView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mImageView.setMinimumTileDpi(160);
        this.setOptimizeDisplay(this.mOptimizeDisplay);
        this.setInitScaleType(this.mInitScaleType);
        this.mImageLoader = BigImageViewer.imageLoader();
        this.mTempImages = new ArrayList<File>();
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.mImageView.setOnClickListener(listener);
    }

    public void setOnLongClickListener(View.OnLongClickListener listener) {
        this.mImageView.setOnLongClickListener(listener);
    }

    public void setInitScaleType(int initScaleType) {
        this.mInitScaleType = initScaleType;
        switch (initScaleType) {
            case 2: {
                this.mImageView.setMinimumScaleType(2);
                break;
            }
            case 3: {
                this.mImageView.setMinimumScaleType(3);
                break;
            }
            default: {
                this.mImageView.setMinimumScaleType(1);
            }
        }
        if (this.mDisplayOptimizeListener != null) {
            this.mDisplayOptimizeListener.setInitScaleType(initScaleType);
        }
    }

    public void setOptimizeDisplay(boolean optimizeDisplay) {
        this.mOptimizeDisplay = optimizeDisplay;
        if (this.mOptimizeDisplay) {
            this.mDisplayOptimizeListener = new DisplayOptimizeListener(this.mImageView);
            this.mImageView.setOnImageEventListener((SubsamplingScaleImageView.OnImageEventListener)this.mDisplayOptimizeListener);
        } else {
            this.mDisplayOptimizeListener = null;
            this.mImageView.setOnImageEventListener(null);
        }
    }

    public void setImageSaveCallback(ImageSaveCallback imageSaveCallback) {
        this.mImageSaveCallback = imageSaveCallback;
    }

    public void setProgressIndicator(ProgressIndicator progressIndicator) {
        this.mProgressIndicator = progressIndicator;
    }

    public String currentImageFile() {
        return this.mCurrentImageFile == null ? "" : this.mCurrentImageFile.getAbsolutePath();
    }

    @RequiresPermission(value="android.permission.WRITE_EXTERNAL_STORAGE")
    public void saveImageIntoGallery() {
        block7: {
            if (this.mCurrentImageFile == null) {
                if (this.mImageSaveCallback != null) {
                    this.mImageSaveCallback.onFail(new IllegalStateException("image not downloaded yet"));
                }
                return;
            }
            try {
                String result = MediaStore.Images.Media.insertImage((ContentResolver)this.getContext().getContentResolver(), (String)this.mCurrentImageFile.getAbsolutePath(), (String)this.mCurrentImageFile.getName(), (String)"");
                if (this.mImageSaveCallback != null) {
                    if (!TextUtils.isEmpty((CharSequence)result)) {
                        this.mImageSaveCallback.onSuccess(result);
                    } else {
                        this.mImageSaveCallback.onFail(new RuntimeException("saveImageIntoGallery fail"));
                    }
                }
            }
            catch (FileNotFoundException e) {
                if (this.mImageSaveCallback == null) break block7;
                this.mImageSaveCallback.onFail(e);
            }
        }
    }

    public void showImage(Uri uri) {
        this.showImage(Uri.EMPTY, uri);
    }

    public void showImage(Uri thumbnail, Uri uri) {
        Log.d((String)"BigImageView", (String)("showImage with thumbnail " + thumbnail + ", " + uri));
        this.url = uri.toString();
        this.mThumbnail = thumbnail;
        this.mImageLoader.loadImage(uri);
    }

    public void onCacheHit(File image) {
        Log.d((String)"BigImageView", (String)("onCacheHit " + image));
        this.mCurrentImageFile = image;
        this.doShowImage(image);
    }

    public void onCacheMiss(final File image) {
        Log.d((String)"BigImageView", (String)("onCacheMiss " + image));
        this.mCurrentImageFile = image;
        this.mTempImages.add(image);
        this.post(new Runnable(){

            @Override
            public void run() {
                BigImageView.this.doShowImage(image);
            }
        });
    }

    public void onStart() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (BigImageView.this.mProgressIndicatorView != null) {
                    // empty if block
                }
                if (BigImageView.this.mProgressIndicator != null) {
                    BigImageView.this.mProgressIndicatorView = BigImageView.this.mProgressIndicator.getView(BigImageView.this);
                    BigImageView.this.addView(BigImageView.this.mProgressIndicatorView);
                    BigImageView.this.mProgressIndicator.onStart();
                }
            }
        });
    }

    public void onProgress(int progress) {
        if (this.mProgressIndicator != null && this.mProgressNotifyRunnable.update(progress)) {
            this.post(this.mProgressNotifyRunnable);
        }
    }

    public void onFail() {
        Log.e((String)"bigimage", (String)"onfail");
    }

    public void onFinish() {
        this.post(new Runnable(){

            @Override
            public void run() {
                BigImageView.this.doOnFinish();
            }
        });
    }

    private void doOnFinish() {
        if (this.mOptimizeDisplay) {
            AnimationSet set = new AnimationSet(true);
            AlphaAnimation animation = new AlphaAnimation(1.0f, 0.0f);
            animation.setDuration(500L);
            animation.setFillAfter(true);
            set.addAnimation((Animation)animation);
            if (this.mThumbnailView != null) {
                this.mThumbnailView.setAnimation((Animation)set);
            }
            if (this.mProgressIndicator != null) {
                this.mProgressIndicator.onFinish();
            }
            if (this.mProgressIndicatorView != null) {
                this.mProgressIndicatorView.setAnimation((Animation)set);
            }
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (BigImageView.this.mThumbnailView != null) {
                        BigImageView.this.mThumbnailView.setVisibility(8);
                    }
                    if (BigImageView.this.mProgressIndicatorView != null) {
                        BigImageView.this.mProgressIndicatorView.setVisibility(8);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
        } else {
            if (this.mProgressIndicator != null) {
                this.mProgressIndicator.onFinish();
            }
            if (this.mThumbnailView != null) {
                this.mThumbnailView.setVisibility(8);
            }
            if (this.mProgressIndicatorView != null) {
                this.mProgressIndicatorView.setVisibility(8);
            }
        }
    }

    @UiThread
    private void doShowImage(File image) {
        this.mImageView.setImage(ImageSource.uri((Uri)Uri.fromFile((File)image)));
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register((Object)this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister((Object)this);
        int size = this.mTempImages.size();
        for (int i = 0; i < size; ++i) {
            this.mTempImages.get(i).delete();
        }
        this.mTempImages.clear();
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onStartEvent(StartEvent event) {
        if (this.url.equals(event.url)) {
            this.onStart();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onProgressEvent(ProgressEvent event) {
        if (this.url.equals(event.url)) {
            this.onProgress(event.progress);
            if (event.progress == 100) {
                this.onFinish();
            }
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onFailEvent(ErrorEvent event) {
        if (this.url.equals(event.url)) {
            this.onFail();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onCacheHitEvent(CacheHitEvent event) {
        if (this.url.equals(event.url)) {
            this.onCacheHit(event.file);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onNoCacheEvent(NoCacheEvent event) {
        if (this.url.equals(event.url)) {
            this.onCacheMiss(event.file);
        }
    }
}

