/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog.bottomsheet;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.hss01248.dialog.R;
import com.hss01248.dialog.ScreenUtil;
import com.hss01248.dialog.Tool;
import com.hss01248.dialog.adapter.SuperLvAdapter;
import com.hss01248.dialog.adapter.SuperLvHolder;
import com.hss01248.dialog.adapter.SuperPagerAdapter;
import com.hss01248.dialog.adapter.SuperPagerHolder;
import com.hss01248.dialog.bottomsheet.BottomSheetBean;
import com.hss01248.dialog.bottomsheet.BottomSheetPagerHolder;
import com.hss01248.dialog.bottomsheet.BottomVpIndicatorHolder;
import com.hss01248.dialog.bottomsheet.BsGvHolder;
import com.hss01248.dialog.bottomsheet.BsLvHolder;
import com.hss01248.dialog.config.BottomSheetStyle;
import com.hss01248.dialog.config.ConfigBean;
import java.util.ArrayList;
import java.util.List;

public class BottomSheetHolder
extends SuperLvHolder<ConfigBean> {
    private TextView tvTitle;
    private View viewLineBottom;
    private TextView tvBottom;

    public BottomSheetHolder(Context context) {
        super(context);
    }

    @Override
    protected void findViews() {
        this.tvTitle = (TextView)this.rootView.findViewById(R.id.tv_title);
        this.viewLineBottom = this.rootView.findViewById(R.id.view_line_bottom);
        this.tvBottom = (TextView)this.rootView.findViewById(R.id.tv_bottom);
    }

    @Override
    protected int setLayoutRes() {
        return R.layout.bottomsheet_lv;
    }

    @Override
    public void assingDatasAndEvents(Context context, @Nullable ConfigBean bean) {
        this.setTitleAndBottomButtonStyle(bean);
        AbsListView adapterView = null;
        if (bean.type == 12) {
            adapterView = this.setListView(context, bean);
        } else if (bean.type == 13) {
            adapterView = this.setGridView(context, bean);
        }
        this.setMdBottomSheetDialogBehaviour((AdapterView)adapterView, context, bean);
    }

    private void setMdBottomSheetDialogBehaviour(AdapterView adapterView, Context context, ConfigBean bean) {
        if (bean.hasBehaviour && bean.dialog instanceof BottomSheetDialog && adapterView != null) {
            Tool.handleScrollInBottomSheetDialog(adapterView);
        }
    }

    private AdapterView setGridView(Context context, ConfigBean bean) {
        if (bean.hasBehaviour) {
            return this.buildSimpleGridView(context, bean);
        }
        if (bean.lvDatas.size() <= 2 * bean.gridColumns) {
            return this.buildSimpleGridView(context, bean);
        }
        return this.buildGridViewWithViewPager(context, bean);
    }

    private AdapterView buildGridViewWithViewPager(Context context, final ConfigBean bean) {
        ViewPager viewPager = new ViewPager(context);
        viewPager.setOverScrollMode(2);
        BottomSheetStyle style2 = bean.bottomSheetStyle;
        int height = ScreenUtil.dip2px(style2.iconSizeDp + style2.txtMarginTopDp + style2.txtSizeSp + 5) * 2 + ScreenUtil.dip2px(style2.gvItemMargin_V);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, height);
        params.topMargin = ScreenUtil.dip2px(style2.gvMarginTopDp);
        params.bottomMargin = ScreenUtil.dip2px(style2.gvMarginBottomDp);
        params.rightMargin = params.leftMargin = ScreenUtil.dip2px(style2.gcMarginLRDp);
        viewPager.setLayoutParams((ViewGroup.LayoutParams)params);
        ArrayList<List<BottomSheetBean>> datas = new ArrayList<List<BottomSheetBean>>();
        ArrayList<BottomSheetBean> data = null;
        for (int i = 0; i < bean.lvDatas.size(); ++i) {
            if (i / bean.gridColumns / 2 == datas.size()) {
                data = new ArrayList<BottomSheetBean>();
                datas.add(data);
                data.add(bean.lvDatas.get(i));
                continue;
            }
            data.add(bean.lvDatas.get(i));
        }
        SuperPagerAdapter pagerAdapter = new SuperPagerAdapter(bean.context){

            @Override
            protected SuperPagerHolder generateNewHolder(Context context, ViewGroup container, int position) {
                return new BottomSheetPagerHolder(context).setConfigBean(bean).setPageNum(position);
            }
        };
        viewPager.setAdapter((PagerAdapter)pagerAdapter);
        pagerAdapter.addAll(datas);
        ((ViewGroup)this.rootView).addView((View)viewPager, 1);
        final BottomVpIndicatorHolder indicatorHolder = new BottomVpIndicatorHolder(context);
        indicatorHolder.assingDatasAndEvents(context, (List<List<BottomSheetBean>>)datas);
        indicatorHolder.onPageSelected(0);
        ((ViewGroup)this.rootView).addView((View)indicatorHolder.mLinearLayout, 2);
        viewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                indicatorHolder.onPageSelected(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        return null;
    }

    private AdapterView buildSimpleGridView(Context context, final ConfigBean bean) {
        GridView listView = new GridView(bean.context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        BottomSheetStyle bottomSheetStyle = bean.bottomSheetStyle;
        params.topMargin = ScreenUtil.dip2px(bottomSheetStyle.gvMarginTopDp);
        params.bottomMargin = ScreenUtil.dip2px(bottomSheetStyle.gvMarginBottomDp);
        params.rightMargin = params.leftMargin = ScreenUtil.dip2px(bottomSheetStyle.gcMarginLRDp);
        listView.setLayoutParams((ViewGroup.LayoutParams)params);
        listView.setNumColumns(bean.gridColumns);
        listView.setVerticalSpacing(ScreenUtil.dip2px(bottomSheetStyle.gvItemMargin_V));
        listView.setHorizontalSpacing(ScreenUtil.dip2px(bottomSheetStyle.gvItemMargin_H));
        if (bean.mAdapter == null) {
            SuperLvAdapter adapter;
            bean.mAdapter = adapter = new SuperLvAdapter(bean.context){

                @Override
                protected SuperLvHolder generateNewHolder(Context context, int itemViewType) {
                    BsGvHolder holder = new BsGvHolder(context);
                    holder.setStyle(bean.bottomSheetStyle);
                    return holder;
                }
            };
        }
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                BottomSheetBean sheetBean = bean.lvDatas.get(position);
                bean.itemListener.onItemClick(sheetBean.text, position);
                Tool.dismiss(bean, true);
            }
        });
        listView.setAdapter((ListAdapter)bean.mAdapter);
        bean.mAdapter.addAll(bean.lvDatas);
        ((ViewGroup)this.rootView).addView((View)listView, 1);
        return listView;
    }

    private AbsListView setListView(Context context, final ConfigBean bean) {
        ListView listView = new ListView(context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        listView.setLayoutParams((ViewGroup.LayoutParams)params);
        listView.setDividerHeight(0);
        if (bean.mAdapter == null) {
            SuperLvAdapter adapter;
            bean.mAdapter = adapter = new SuperLvAdapter(bean.context){

                @Override
                protected SuperLvHolder generateNewHolder(Context context, int itemViewType) {
                    return new BsLvHolder(context);
                }
            };
        }
        listView.setAdapter((ListAdapter)bean.mAdapter);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                BottomSheetBean sheetBean = bean.lvDatas.get(position);
                bean.itemListener.onItemClick(sheetBean.text, position);
                Tool.dismiss(bean, true);
            }
        });
        bean.mAdapter.addAll(bean.lvDatas);
        ((ViewGroup)this.rootView).addView((View)listView, 1);
        return listView;
    }

    private void setTitleAndBottomButtonStyle(final ConfigBean bean) {
        if (TextUtils.isEmpty((CharSequence)bean.title)) {
            this.tvTitle.setVisibility(8);
        } else {
            this.tvTitle.setText(bean.title);
            this.tvTitle.setVisibility(0);
        }
        if (!TextUtils.isEmpty((CharSequence)bean.bottomTxt)) {
            this.tvBottom.setVisibility(0);
            this.tvBottom.setText(bean.bottomTxt);
            this.tvBottom.setTextSize((float)bean.bottomSheetStyle.bottomTxtSizeSp);
            this.tvBottom.setTextColor(this.tvBottom.getContext().getResources().getColor(bean.bottomSheetStyle.bottomTxtColor));
            this.tvBottom.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (bean.itemListener != null) {
                        bean.itemListener.onBottomBtnClick();
                    }
                    Tool.dismiss(bean);
                }
            });
        } else {
            this.tvBottom.setVisibility(8);
        }
    }
}

