/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog;

import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.hss01248.dialog.R;
import com.hss01248.dialog.Tool;
import com.hss01248.dialog.config.ConfigBean;

public class WindowAdjuster {
    public static void adjust(Window window, ConfigBean bean) {
        WindowAdjuster.setGravity(window, bean);
        WindowAdjuster.setBackground(window, bean);
        WindowAdjuster.setIfTypeToast(window, bean);
        WindowAdjuster.setDimBehind(window, bean);
        WindowAdjuster.setAnimation(window, bean);
        WindowAdjuster.setStyleOnLayout(window, bean);
    }

    private static void setStyleOnLayout(final Window window, final ConfigBean bean) {
        window.getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                WindowAdjuster.adjustSize(window, bean);
                WindowAdjuster.showKeyBorarIfNeed(window, bean);
                window.getDecorView().getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    private static void showKeyBorarIfNeed(Window window, ConfigBean bean) {
        window.setSoftInputMode(48);
        Tool.showSoftKeyBoardDelayed(bean.needSoftKeyboard, bean.viewHolder);
        Tool.showSoftKeyBoardDelayed(bean.needSoftKeyboard, bean.customContentHolder);
    }

    private static void setGravity(Window window, ConfigBean bean) {
        window.setGravity(bean.gravity);
    }

    private static void setAnimation(Window window, ConfigBean bean) {
        if (bean.showAsActivity) {
            return;
        }
        int gravity = bean.gravity;
        if (gravity == 80 || gravity == 81) {
            window.setWindowAnimations(R.style.ani_bottom);
        } else if (gravity == 17) {
            // empty if block
        }
    }

    private static void setDimBehind(Window window, ConfigBean bean) {
        if (bean.dimBehind) {
            window.setDimAmount(0.6f);
        } else {
            window.setDimAmount(0.0f);
        }
    }

    private static void setIfTypeToast(Window window, ConfigBean bean) {
    }

    private static void setBackground(Window window, ConfigBean bean) {
        if (!bean.showAsActivity && bean.bgRes != 0) {
            window.setBackgroundDrawableResource(bean.bgRes);
        }
    }

    private static void adjustSize(Window window, ConfigBean bean) {
        View rootView = window.getDecorView();
        WindowManager.LayoutParams wl = window.getAttributes();
        int width = window.getWindowManager().getDefaultDisplay().getWidth();
        int height = window.getWindowManager().getDefaultDisplay().getHeight();
        int measuredHeight = rootView.getMeasuredHeight();
        int measuredWidth = rootView.getMeasuredWidth();
        float widthRatio = 0.0f;
        float heightRatio = 0.0f;
        if (width > height) {
            widthRatio = 0.5f;
        }
        if (bean.maxWidthPercent > 0.0f && (float)measuredWidth > bean.maxWidthPercent * (float)width) {
            widthRatio = bean.maxWidthPercent;
        }
        if (bean.forceWidthPercent > 0.0f && bean.forceWidthPercent <= 1.0f) {
            widthRatio = bean.forceWidthPercent;
        }
        if (bean.maxHeightPercent > 0.0f && (float)measuredHeight > bean.maxHeightPercent * (float)height) {
            heightRatio = bean.maxHeightPercent;
        }
        if (bean.forceHeightPercent > 0.0f && bean.forceHeightPercent <= 1.0f) {
            heightRatio = bean.forceHeightPercent;
        }
        boolean needUpdate = false;
        if (widthRatio > 0.0f) {
            wl.width = (int)((float)width * widthRatio);
            needUpdate = true;
        }
        if (heightRatio > 0.0f) {
            wl.height = (int)((float)height * heightRatio);
            needUpdate = true;
        }
        if (needUpdate) {
            window.setAttributes(wl);
        }
    }
}

