/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog;

import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.hss01248.dialog.StyledDialog;
import java.lang.reflect.Method;

public class ScreenUtil {
    public static int getScreenHeight() {
        int height = ScreenUtil.getWindowManager().getDefaultDisplay().getHeight();
        return height;
    }

    public static int getScreenWidth() {
        int height = ScreenUtil.getWindowManager().getDefaultDisplay().getWidth();
        return height;
    }

    public static int getgetScreenHeightHasVirtualKey() {
        int dpi = 0;
        Display display = ScreenUtil.getWindowManager().getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        try {
            Class<?> c = Class.forName("android.view.Display");
            Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
            method.invoke((Object)display, dm);
            dpi = dm.heightPixels;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dpi;
    }

    public static WindowManager getWindowManager() {
        return (WindowManager)StyledDialog.context.getSystemService("window");
    }

    public static int px2dip(float pxValue) {
        float scale = StyledDialog.context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int dip2px(float dipValue) {
        float scale = StyledDialog.context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    private static float sp2px(float spValue, float fontScale) {
        return spValue * fontScale + 0.5f;
    }

    public static float sp2px(float spValue) {
        float scale = StyledDialog.context.getResources().getDisplayMetrics().density;
        return ScreenUtil.sp2px(spValue, scale);
    }
}

