/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import com.hss01248.dialog.DialogsMaintainer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ActivityStackManager {
    private static ActivityStackManager sInstance = new ActivityStackManager();
    private WeakReference<Activity> topAttachedActivityWeakRef;
    private static Stack<Activity> mActivityStack = new Stack();
    private static boolean isDebug;
    static boolean hasInit;

    public static boolean isApkInDebug(Context context) {
        try {
            ApplicationInfo info = context.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void init(Application application) {
        isDebug = ActivityStackManager.isApkInDebug((Context)application);
        if (hasInit) {
            return;
        }
        hasInit = true;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
                ActivityStackManager.getInstance().addActivity(activity);
                ActivityStackManager.getInstance().setTopAttached(activity);
            }

            public void onActivityStarted(@NonNull Activity activity) {
            }

            public void onActivityResumed(@NonNull Activity activity) {
                ActivityStackManager.getInstance().setTopAttached(activity);
            }

            public void onActivityPaused(@NonNull Activity activity) {
                if (activity.isFinishing()) {
                    ActivityStackManager.getInstance().removeActivity(activity);
                }
                DialogsMaintainer.onPause(activity);
            }

            public void onActivityStopped(@NonNull Activity activity) {
            }

            public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
            }

            public void onActivityDestroyed(@NonNull Activity activity) {
                ActivityStackManager.getInstance().removeActivity(activity);
            }
        });
    }

    private ActivityStackManager() {
    }

    public static ActivityStackManager getInstance() {
        return sInstance;
    }

    public Stack<Activity> getActivityStack() {
        if (mActivityStack != null) {
            return mActivityStack;
        }
        return null;
    }

    public Activity getTopActivity() {
        Activity currentActivity = null;
        if (this.topAttachedActivityWeakRef != null && this.topAttachedActivityWeakRef.get() != null && ActivityStackManager.isUsable(currentActivity = (Activity)this.topAttachedActivityWeakRef.get())) {
            return currentActivity;
        }
        if (mActivityStack.size() > 0) {
            currentActivity = this.getUsableActivity(mActivityStack);
        }
        return currentActivity;
    }

    private Activity getUsableActivity(Stack<Activity> mActivityStack) {
        for (int i = mActivityStack.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)mActivityStack.get(i);
            if (!ActivityStackManager.isUsable(activity)) continue;
            return activity;
        }
        return null;
    }

    public Activity getTopActivity(Class activityExpected) {
        for (int i = mActivityStack.size() - 1; i >= 0; --i) {
            Activity activity = (Activity)mActivityStack.get(i);
            if (!ActivityStackManager.isUsable(activity) || !activity.getClass().equals(activityExpected)) continue;
            return activity;
        }
        return null;
    }

    public Activity getActivity(Class activityExpected) {
        if (mActivityStack == null) {
            return null;
        }
        for (Activity activity1 : mActivityStack) {
            if (!activity1.getClass().equals(activityExpected)) continue;
            return activity1;
        }
        return null;
    }

    public Activity getActivityAt(int index) {
        Activity activity = null;
        if (mActivityStack == null) {
            return null;
        }
        if (mActivityStack.size() >= index) {
            activity = (Activity)mActivityStack.get(index);
        }
        return activity;
    }

    public boolean finishActivityByIdx(int idxTop) {
        if (mActivityStack.isEmpty()) {
            return false;
        }
        int index = mActivityStack.size() - idxTop;
        Activity activity = (Activity)mActivityStack.remove(index);
        if (activity != null && !activity.isFinishing()) {
            activity.finish();
            return true;
        }
        return true;
    }

    public void setTopAttached(Activity activity) {
        this.topAttachedActivityWeakRef = new WeakReference<Activity>(activity);
    }

    public static boolean isUsable(Activity activity) {
        if (activity == null) {
            return false;
        }
        if (activity.isFinishing()) {
            return false;
        }
        return Build.VERSION.SDK_INT < 17 || !activity.isDestroyed();
    }

    public int size() {
        return mActivityStack.size();
    }

    public void addActivity(Activity activity) {
        if (mActivityStack == null) {
            mActivityStack = new Stack();
        }
        if (activity != null && !mActivityStack.contains(activity)) {
            mActivityStack.add(activity);
        }
        this.printStack("onCreate:\n");
    }

    public void removeActivity(Activity activity) {
        if (mActivityStack == null) {
            return;
        }
        if (mActivityStack.contains(activity)) {
            mActivityStack.remove(activity);
        }
        this.printStack("onDestory:\n");
    }

    private void printStack(String time) {
        if (!isDebug) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = mActivityStack.size() - 1; i >= 0; --i) {
            builder.append(((Activity)mActivityStack.get(i)).getClass().getSimpleName()).append("-:").append(i).append("\n");
        }
        Log.i((String)"printStack dialog", (String)(time + builder.toString()));
    }

    public boolean isActivityAlive(Class<?> cls) {
        if (mActivityStack == null) {
            return false;
        }
        for (Activity activity1 : mActivityStack) {
            if (!activity1.getClass().equals(cls)) continue;
            return true;
        }
        return false;
    }

    public void finishActivity(Activity activity) {
        if (mActivityStack == null) {
            return;
        }
        if (activity != null) {
            mActivityStack.remove(activity);
            activity.finish();
        }
    }

    public void finishActivity(Class<?> cls) {
        if (mActivityStack == null) {
            return;
        }
        try {
            Iterator iterator = mActivityStack.iterator();
            ArrayList<Activity> destoryedActivities = new ArrayList<Activity>();
            while (iterator.hasNext()) {
                Activity activity = (Activity)iterator.next();
                if (!activity.getClass().equals(cls)) continue;
                iterator.remove();
                destoryedActivities.add(activity);
            }
            if (destoryedActivities.size() > 0) {
                for (Activity activity : destoryedActivities) {
                    if (activity.isFinishing()) {
                        return;
                    }
                    if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
                        return;
                    }
                    activity.finish();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finishActivitiesExcept(Class<?> ... cls) {
        if (mActivityStack.isEmpty()) {
            return;
        }
        if (cls.length == 0) {
            return;
        }
        List<Class<?>> list = Arrays.asList(cls);
        Iterator iterator = mActivityStack.iterator();
        while (iterator.hasNext()) {
            Activity activity = (Activity)iterator.next();
            Class<?> clazz = activity.getClass();
            if (list.contains(clazz)) continue;
            iterator.remove();
            activity.finish();
        }
    }

    public void finishAllActivityAndExit() {
        if (null != mActivityStack) {
            int size = mActivityStack.size();
            for (int i = 0; i < size; ++i) {
                if (null == mActivityStack.get(i)) continue;
                try {
                    ActivityCompat.finishAfterTransition((Activity)((Activity)mActivityStack.get(i)));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void clean() {
        if (sInstance != null) {
            mActivityStack.clear();
            mActivityStack = null;
            sInstance = null;
        }
    }

    static {
        hasInit = false;
    }
}

