/*
 * Decompiled with CFR 0.152.
 */
package com.hss01248.dialog.ios;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.hss01248.dialog.R;
import com.hss01248.dialog.StyledDialog;
import com.hss01248.dialog.Tool;
import com.hss01248.dialog.adapter.SuperLvHolder;
import com.hss01248.dialog.config.ConfigBean;

public class IosCenterItemHolder
extends SuperLvHolder<ConfigBean> {
    public ListView lv;
    public TextView textView;
    private View line;

    public IosCenterItemHolder(Context context) {
        super(context);
    }

    @Override
    protected void findViews() {
        this.lv = (ListView)this.rootView.findViewById(R.id.lv);
        this.textView = (TextView)this.rootView.findViewById(R.id.tv_title);
        this.line = this.rootView.findViewById(R.id.v_line);
        this.lv.setDivider((Drawable)new ColorDrawable(this.lv.getResources().getColor(R.color.dialogutil_line_dd)));
        this.lv.setDividerHeight(1);
    }

    @Override
    protected int setLayoutRes() {
        return R.layout.dialog_ios_center_item;
    }

    @Override
    public void assingDatasAndEvents(final Context context, final ConfigBean bean) {
        if (TextUtils.isEmpty((CharSequence)bean.title)) {
            this.textView.setVisibility(8);
            this.line.setVisibility(8);
        } else {
            this.textView.setVisibility(0);
            this.line.setVisibility(0);
            this.textView.setText(bean.title);
            if (bean.titleTxtSize > 0) {
                this.textView.setTextSize((float)bean.titleTxtSize);
            }
            if (bean.titleTxtColor != 0) {
                this.textView.setTextColor(StyledDialog.context.getResources().getColor(bean.titleTxtColor));
            }
        }
        this.lv.setAdapter((ListAdapter)new BaseAdapter(){

            public int getCount() {
                return bean.wordsIos.size();
            }

            public Object getItem(int position) {
                return bean.wordsIos.get(position);
            }

            public long getItemId(int position) {
                return position;
            }

            public View getView(final int position, View convertView, ViewGroup parent) {
                RelativeLayout root = (RelativeLayout)View.inflate((Context)context, (int)R.layout.item_btn_bottomalert, null);
                Button view = (Button)root.findViewById(R.id.btn);
                if (this.getCount() >= 2) {
                    if (position == 0) {
                        if (TextUtils.isEmpty((CharSequence)bean.title)) {
                            view.setBackgroundResource(R.drawable.selector_btn_press_all_top);
                        } else {
                            view.setBackgroundResource(R.drawable.selector_btn_press_no_corner);
                        }
                    } else if (position == this.getCount() - 1) {
                        view.setBackgroundResource(R.drawable.selector_btn_press_all_bottom);
                    } else {
                        view.setBackgroundResource(R.drawable.selector_btn_press_no_corner);
                    }
                } else {
                    view.setBackgroundResource(R.drawable.selector_btn_press_all);
                }
                view.setText(bean.wordsIos.get(position));
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        bean.itemListener.onItemClick(bean.wordsIos.get(position), position);
                        Tool.dismiss(bean, true);
                    }
                });
                return root;
            }
        });
    }
}

