/*
 * Decompiled with CFR 0.152.
 */
package ozaydin.serkan.com.image_zoom_view;

import android.app.Activity;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import ozaydin.serkan.com.image_zoom_view.ImageProperties;
import ozaydin.serkan.com.image_zoom_view.ImageSaveProperties;
import ozaydin.serkan.com.image_zoom_view.ImageViewZoomConfig;
import ozaydin.serkan.com.image_zoom_view.Permission;
import ozaydin.serkan.com.image_zoom_view.R;

public class ImageViewZoomBottomSheet
extends BottomSheetDialogFragment {
    private View root;
    private LinearLayout downloadImageLinearLayout;
    private ImageViewZoomConfig config;
    private Bitmap bitmap;
    private ImageSaveProperties imageSaveProperties;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.root = inflater.inflate(R.layout.bottom_sheet_layout, container, false);
        this.init();
        this.configuration();
        this.downloadImageLinearLayout.setOnClickListener(view -> {
            if (Permission.askPermissionForFragment((Activity)this.requireActivity(), (Fragment)this, "android.permission.WRITE_EXTERNAL_STORAGE", this.imageSaveProperties.getPermissionRequestCode())) {
                this.saveImage();
            }
        });
        return this.root;
    }

    public void configuration() {
        if (this.config.getIsSave()) {
            this.downloadImageLinearLayout.setVisibility(0);
        }
    }

    public void setConfiguration(FragmentManager fragmentManager, ImageViewZoomConfig imageViewZoomConfig, Bitmap bitmap) {
        super.show(fragmentManager, "ContentValues");
        this.config = imageViewZoomConfig;
        this.bitmap = bitmap;
    }

    public void setConfiguration(FragmentManager fragmentManager, ImageViewZoomConfig imageViewZoomConfig, ImageSaveProperties imageSaveProperties, Bitmap bitmap) {
        super.show(fragmentManager, "ContentValues");
        this.config = imageViewZoomConfig;
        this.imageSaveProperties = imageSaveProperties;
        this.bitmap = bitmap;
    }

    public void init() {
        this.downloadImageLinearLayout = (LinearLayout)this.root.findViewById(R.id.bottom_sheet_layout_download_image_linear_layout);
    }

    public void saveImage() {
        ImageProperties.saveImage(this.bitmap, this.imageSaveProperties.getFolderName(), this.imageSaveProperties.getFileName(), this.imageSaveProperties.getCompressFormat(), this.imageSaveProperties.getSaveFileListener());
        this.dismiss();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (grantResults[0] == 0) {
            this.saveImage();
        }
    }
}

