/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.stream;

import com.github.housepower.data.Block;
import com.github.housepower.misc.SQLLexer;
import com.github.housepower.misc.Validate;
import com.github.housepower.stream.NativeInputFormat;
import java.sql.SQLException;
import java.util.BitSet;

public class ValuesNativeInputFormat
implements NativeInputFormat {
    private final SQLLexer lexer;

    public ValuesNativeInputFormat(int pos, String sql) {
        this.lexer = new SQLLexer(pos, sql);
    }

    @Override
    public void fill(Block block) throws SQLException {
        BitSet constIdxFlags = new BitSet(block.columnCnt());
        while (true) {
            char nextChar = this.lexer.character();
            if (this.lexer.eof() || nextChar == ';') break;
            if (nextChar == ',') {
                nextChar = this.lexer.character();
            }
            Validate.isTrue(nextChar == '(');
            for (int columnIdx = 0; columnIdx < block.columnCnt(); ++columnIdx) {
                if (columnIdx > 0) {
                    Validate.isTrue(this.lexer.character() == ',');
                }
                constIdxFlags.set(columnIdx);
                block.setObject(columnIdx, block.getColumn(columnIdx).type().deserializeText(this.lexer));
            }
            Validate.isTrue(this.lexer.character() == ')');
            block.appendRow();
        }
        for (int columnIdx = 0; columnIdx < block.columnCnt(); ++columnIdx) {
            if (!constIdxFlags.get(columnIdx)) continue;
            block.incPlaceholderIndexes(columnIdx);
        }
    }
}

