/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.protocol;

import com.github.housepower.client.NativeContext;
import com.github.housepower.exception.NotImplementedException;
import com.github.housepower.protocol.DataResponse;
import com.github.housepower.protocol.EOFStreamResponse;
import com.github.housepower.protocol.ExceptionResponse;
import com.github.housepower.protocol.ExtremesResponse;
import com.github.housepower.protocol.HelloResponse;
import com.github.housepower.protocol.PongResponse;
import com.github.housepower.protocol.ProfileInfoResponse;
import com.github.housepower.protocol.ProgressResponse;
import com.github.housepower.protocol.TotalsResponse;
import com.github.housepower.serde.BinaryDeserializer;
import java.io.IOException;
import java.sql.SQLException;

public interface Response {
    public ProtoType type();

    public static Response readFrom(BinaryDeserializer deserializer, NativeContext.ServerContext info) throws IOException, SQLException {
        switch ((int)deserializer.readVarInt()) {
            case 0: {
                return HelloResponse.readFrom(deserializer);
            }
            case 1: {
                return DataResponse.readFrom(deserializer, info);
            }
            case 2: {
                throw ExceptionResponse.readExceptionFrom(deserializer);
            }
            case 3: {
                return ProgressResponse.readFrom(deserializer);
            }
            case 4: {
                return PongResponse.readFrom(deserializer);
            }
            case 5: {
                return EOFStreamResponse.readFrom(deserializer);
            }
            case 6: {
                return ProfileInfoResponse.readFrom(deserializer);
            }
            case 7: {
                return TotalsResponse.readFrom(deserializer, info);
            }
            case 8: {
                return ExtremesResponse.readFrom(deserializer, info);
            }
            case 9: {
                throw new NotImplementedException("RESPONSE_TABLES_STATUS_RESPONSE");
            }
        }
        throw new IllegalStateException("Accept the id of response that is not recognized by Server.");
    }

    public static enum ProtoType {
        RESPONSE_HELLO(0),
        RESPONSE_DATA(1),
        RESPONSE_EXCEPTION(2),
        RESPONSE_PROGRESS(3),
        RESPONSE_PONG(4),
        RESPONSE_END_OF_STREAM(5),
        RESPONSE_PROFILE_INFO(6),
        RESPONSE_TOTALS(7),
        RESPONSE_EXTREMES(8),
        RESPONSE_TABLES_STATUS_RESPONSE(9);

        private final int id;

        private ProtoType(int id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }
    }
}

