/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss.utils;

import com.github.houbie.lesscss.utils.StringBuilderWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static String read(URL url) throws IOException {
        return IOUtils.read(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(URL url, String encoding) throws IOException {
        InputStream is = null;
        StringBuilderWriter writer = new StringBuilderWriter();
        try {
            is = url.openStream();
            IOUtils.copy(is, writer, encoding);
            String string = writer.toString();
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static String read(File file) throws IOException {
        return IOUtils.read(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file, String encoding) throws IOException {
        FileInputStream is = null;
        StringBuilderWriter writer = new StringBuilderWriter();
        try {
            is = new FileInputStream(file);
            IOUtils.copy(is, writer, encoding);
            String string = writer.toString();
            return string;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }

    public static String read(InputStream inputStream) throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        IOUtils.copyLarge(new InputStreamReader(inputStream), writer);
        return writer.toString();
    }

    public static String read(Reader reader) throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        IOUtils.copyLarge(reader, writer);
        return writer.toString();
    }

    public static void copy(InputStream input, Writer output, String encoding) throws IOException {
        if (encoding == null) {
            IOUtils.copy(input, output);
        } else {
            InputStreamReader in = new InputStreamReader(input, encoding);
            IOUtils.copy(in, output);
        }
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        IOUtils.copy(in, output);
    }

    public static int copy(Reader input, Writer output) throws IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        int n;
        char[] buffer = new char[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void writeFile(String content, File destination, String charsetName) throws IOException {
        if (!destination.exists()) {
            destination.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(destination);
        IOUtils.write(content, fos, charsetName);
    }

    public static void write(String content, OutputStream outputStream, String charsetName) throws IOException {
        OutputStreamWriter writer = charsetName != null ? new OutputStreamWriter(outputStream, charsetName) : new OutputStreamWriter(outputStream);
        IOUtils.copyLarge(new StringReader(content), writer);
        writer.flush();
        writer.close();
    }
}

