/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss.resourcereader;

import com.github.houbie.lesscss.resourcereader.ResourceReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingResourceReader
implements ResourceReader {
    private static final Logger logger = LoggerFactory.getLogger(TrackingResourceReader.class);
    private ResourceReader resourceReader;
    private List<String> imports = new ArrayList<String>();

    public TrackingResourceReader(ResourceReader resourceReader) {
        this.resourceReader = resourceReader;
    }

    @Override
    public boolean canRead(String location) {
        return this.resourceReader.canRead(location);
    }

    @Override
    public String read(String location) throws IOException {
        logger.debug("reading @import " + location);
        if (this.resourceReader == null) {
            throw new RuntimeException("Error in less compilation: import of " + location + " failed because no ResourceReader is configured");
        }
        this.imports.add(this.normalize(location));
        return this.resourceReader.read(location);
    }

    @Override
    public byte[] readBytes(String location) throws IOException {
        return this.resourceReader != null ? this.resourceReader.readBytes(location) : null;
    }

    public String normalize(String location) {
        try {
            return new URI(location).normalize().getPath();
        }
        catch (URISyntaxException e) {
            return location;
        }
    }

    @Override
    public long lastModified(String location) {
        return this.resourceReader.lastModified(location);
    }

    public List<String> getReadResources() {
        return this.imports;
    }

    public ResourceReader getDelegate() {
        return this.resourceReader;
    }
}

