/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss.resourcereader;

import com.github.houbie.lesscss.resourcereader.ResourceReader;
import com.github.houbie.lesscss.utils.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemResourceReader
implements ResourceReader {
    private static Logger logger = LoggerFactory.getLogger(FileSystemResourceReader.class);
    private File[] baseDirs;
    private String encoding;

    public FileSystemResourceReader() {
        this(new File("."));
    }

    public FileSystemResourceReader(String encoding) {
        this(encoding, new File("."));
    }

    public FileSystemResourceReader(File ... baseDirs) {
        this((String)null, baseDirs);
    }

    public FileSystemResourceReader(String encoding, File ... baseDirs) {
        this.copyBaseDirs(baseDirs);
        this.encoding = encoding;
    }

    private void copyBaseDirs(File[] baseDirs) {
        this.baseDirs = new File[baseDirs.length];
        for (int i = 0; i < baseDirs.length; ++i) {
            this.baseDirs[i] = baseDirs[i].getAbsoluteFile();
        }
    }

    @Override
    public boolean canRead(String location) {
        File file = this.resolve(location);
        return file != null && file.exists();
    }

    @Override
    public String read(String location) throws IOException {
        File file = this.resolve(location);
        if (file != null) {
            logger.debug("reading {}", (Object)location);
            return IOUtils.read(file, this.encoding);
        }
        return null;
    }

    @Override
    public byte[] readBytes(String location) throws IOException {
        File file = this.resolve(location);
        if (file != null) {
            logger.debug("reading bytes {}", (Object)location);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copyLarge(new FileInputStream(file), bos);
            return bos.toByteArray();
        }
        return null;
    }

    private File resolve(String location) {
        File file = this.resolveRelative(location);
        if (file == null) {
            file = this.resolveAbsolute(location);
        }
        return file;
    }

    private File resolveRelative(String location) {
        for (File dir : this.baseDirs) {
            logger.debug("resolving {} relative to {}", (Object)location, (Object)dir.getAbsolutePath());
            File file = new File(dir, location);
            if (!file.canRead()) continue;
            return file;
        }
        return null;
    }

    private File resolveAbsolute(String location) {
        File file = new File(location);
        return file.canRead() ? file : null;
    }

    @Override
    public long lastModified(String location) {
        File file = this.resolve(location);
        return file == null ? Long.MAX_VALUE : file.lastModified();
    }

    public File[] getBaseDirs() {
        return this.baseDirs;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemResourceReader that = (FileSystemResourceReader)o;
        if (!Arrays.equals(this.baseDirs, that.baseDirs)) {
            return false;
        }
        return !(this.encoding != null ? !this.encoding.equals(that.encoding) : that.encoding != null);
    }

    public int hashCode() {
        int result = this.baseDirs != null ? Arrays.hashCode(this.baseDirs) : 0;
        result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
        return result;
    }
}

