/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss.engine;

import com.github.houbie.lesscss.LessCompiler;
import com.github.houbie.lesscss.LessParseException;
import com.github.houbie.lesscss.engine.CompilationOptions;
import com.github.houbie.lesscss.engine.LessCompilationEngine;
import com.github.houbie.lesscss.resourcereader.ResourceReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngineLessCompilationEngine
implements LessCompilationEngine {
    private static Logger logger = LoggerFactory.getLogger(ScriptEngineLessCompilationEngine.class);
    private static final String JS_ALL_MIN_JS = "js/all-min.js";
    private static final String LESS_SCRIPT = "js/less-rhino-1.7.0-mod.js";
    private static final String MINIFY_SCRIPT = "js/cssmin.js";
    private static final String COMPILE_SCRIPT = "js/compile.js";
    private static final boolean MINIFIED = true;
    private ScriptEngine scriptEngine;

    public ScriptEngineLessCompilationEngine(String scriptEngineName) {
        logger.info("creating new NashornEngine");
        ScriptEngineManager factory = new ScriptEngineManager();
        this.scriptEngine = factory.getEngineByName(scriptEngineName);
        if (this.scriptEngine == null) {
            throw new RuntimeException("The ScriptEngine " + scriptEngineName + " could not be loaded");
        }
    }

    public ScriptEngineLessCompilationEngine(ScriptEngine scriptEngine) {
        logger.info("creating new engine with {}", scriptEngine.getClass());
        this.scriptEngine = scriptEngine;
    }

    @Override
    public void initialize(Reader customJavaScriptReader) {
        try {
            if (customJavaScriptReader != null) {
                this.scriptEngine.eval(customJavaScriptReader);
            }
            this.scriptEngine.eval(this.getLessScriptReader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Reader getLessScriptReader() {
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream concatenatedScripts = cl.getResourceAsStream(JS_ALL_MIN_JS);
        return new InputStreamReader(concatenatedScripts);
    }

    @Override
    public LessCompiler.CompilationDetails compile(String less, CompilationOptions compilationOptions, ResourceReader resourceReader) {
        Map result;
        try {
            result = (Map)((Invocable)((Object)this.scriptEngine)).invokeFunction("compile", less, compilationOptions, resourceReader);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while compiling less", e);
        }
        if (result.get("parseException") != null) {
            throw new LessParseException((String)result.get("parseException"));
        }
        return new LessCompiler.CompilationDetails((String)result.get("css"), (String)result.get("sourceMapContent"));
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }
}

