/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss.engine;

import com.github.houbie.lesscss.LessCompiler;
import com.github.houbie.lesscss.LessParseException;
import com.github.houbie.lesscss.compiledjs.LessImpl;
import com.github.houbie.lesscss.engine.CompilationOptions;
import com.github.houbie.lesscss.engine.LessCompilationEngine;
import com.github.houbie.lesscss.resourcereader.ResourceReader;
import com.github.houbie.mozilla.javascript.Callable;
import com.github.houbie.mozilla.javascript.Context;
import com.github.houbie.mozilla.javascript.Function;
import com.github.houbie.mozilla.javascript.Scriptable;
import com.github.houbie.mozilla.javascript.ScriptableObject;
import com.github.houbie.mozilla.javascript.tools.shell.Global;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RhinoLessCompilationEngine
implements LessCompilationEngine {
    private static Logger logger = LoggerFactory.getLogger(RhinoLessCompilationEngine.class);
    private boolean initialized;
    private Scriptable scope;
    private Function compileFunction;

    @Override
    public void initialize(Reader customJavaScriptReader) {
        if (!this.initialized) {
            Context cx = Context.enter();
            logger.debug("Using implementation version: " + cx.getImplementationVersion());
            cx.setOptimizationLevel(9);
            cx.setLanguageVersion(170);
            Global global = new Global();
            global.init(cx);
            this.scope = cx.initStandardObjects((ScriptableObject)global);
            new LessImpl().exec(cx, this.scope);
            if (customJavaScriptReader != null) {
                try {
                    cx.evaluateReader(this.scope, customJavaScriptReader, "customJavaScript", 1, null);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.compileFunction = (Function)this.scope.get("compile", this.scope);
            this.initialized = true;
        }
    }

    @Override
    public LessCompiler.CompilationDetails compile(String less, CompilationOptions compilationOptions, ResourceReader resourceReader) {
        Map result;
        if (!this.initialized) {
            throw new RuntimeException("execute called, but not yet initialized");
        }
        try {
            Object[] args = new Object[]{less, compilationOptions, resourceReader};
            result = (Map)Context.call(null, (Callable)this.compileFunction, (Scriptable)this.scope, (Scriptable)this.scope, (Object[])args);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while compiling less", e);
        }
        if (result.get("parseException") != null) {
            throw new LessParseException(result.get("parseException").toString());
        }
        return new LessCompiler.CompilationDetails((String)result.get("css"), (String)result.get("sourceMapContent"));
    }
}

