/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbie.lesscss;

import com.github.houbie.lesscss.Options;
import com.github.houbie.lesscss.resourcereader.FileSystemResourceReader;
import com.github.houbie.lesscss.resourcereader.ResourceReader;
import com.github.houbie.lesscss.utils.LogbackConfigurator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;

public class LesscCommandLineParser {
    static final String HELP_OPTION = "help";
    static final String INCLUDE_PATH_OPTION = "include-path";
    static final String DEPENDS_OPTION = "depends";
    static final String NO_IE_COMPAT_OPTION = "no-ie-compat";
    static final String NO_JS_OPTION = "no-js";
    static final String LINT_OPTION = "lint";
    static final String SILENT_OPTION = "silent";
    static final String STRICT_IMPORTS_OPTION = "strict-imports";
    static final String VERSION_OPTION = "version";
    static final String COMPRESS_OPTION = "compress";
    static final String SOURCE_MAP_OPTION = "source-map";
    static final String SOURCE_MAP__ROOTPATH_OPTION = "source-map-rootpath";
    static final String SOURCE_MAP__BASEPATH_OPTION = "source-map-basepath";
    static final String SOURCE_MAP_LESS_INLINE_OPTION = "source-map-less-inline";
    static final String SOURCE_MAP_MAP_INLINE_OPTION = "source-map-map-inline";
    static final String SOURCE_MAP_URL_OPTION = "source-map-url";
    static final String ROOT_PATH_OPTION = "rootpath";
    static final String RELATIVE_URLS_OPTION = "relative-urls";
    static final String STRICT_MATH_OPTION = "strict-math";
    static final String STRICT_UNITS_OPTION = "strict-units";
    static final String GLOBAL_VAR_OPTION = "global-var";
    static final String MODIFY_VAR_OPTION = "modify-var";
    static final String CUSTOM_JS_OPTION = "custom-js";
    static final String ENCODING_OPTION = "encoding";
    static final String CACHE_DIR_OPTION = "cache-dir";
    static final String DAEMON_OPTION = "daemon";
    static final String ENGINE_OPTION = "engine";
    static final String VERBOSE_OPTION = "verbose";
    static final String YUI_COMPRESS_OPTION = "yui-compress";
    static final String OPTIMIZATION_LEVEL_OPTION = "optimization";
    static final String LINE_NUMBERS_OPTION = "line-numbers";
    static final String MAIN_COMMAND = "lessc";
    static final String HELP_HEADER = "[option option=parameter ...] <source> [destination]";
    static final String HELP_FOOTER = "";
    private final Pattern nameValuePattern = Pattern.compile("(\"|')?(\\w+)=(\\w+)(\"'|')?");
    private final String version;
    private Options options;
    private String sourceLocation;
    private File sourceMapFile;
    private File destination;
    private ResourceReader resourceReader;
    private String encoding;
    private Reader customJsReader;
    private boolean verbose;
    private File cacheDir;
    private boolean daemon;
    private String engine;

    public LesscCommandLineParser(String version) {
        this.version = version;
    }

    public boolean parse(String[] args) throws ParseException, IOException {
        org.apache.commons.cli.Options cliOptions = LesscCommandLineParser.createOptions();
        CommandLine commandLine = this.parseCommandLine(args, cliOptions);
        if (this.printHelp(commandLine, cliOptions) || this.printVersion(commandLine)) {
            return true;
        }
        this.process(commandLine);
        return false;
    }

    private static org.apache.commons.cli.Options createOptions() {
        org.apache.commons.cli.Options result = new org.apache.commons.cli.Options();
        result.addOption("h", HELP_OPTION, false, "Print help (this message) and exit.");
        OptionBuilder.withLongOpt((String)INCLUDE_PATH_OPTION);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Set include paths. Separated by `:'. Use `;' on Windows.");
        result.addOption(OptionBuilder.create());
        result.addOption("M", DEPENDS_OPTION, false, "Output a makefile import dependency list to stdout.");
        OptionBuilder.withLongOpt((String)NO_IE_COMPAT_OPTION);
        OptionBuilder.withDescription((String)"Disable IE compatibility checks.");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)NO_JS_OPTION);
        OptionBuilder.withDescription((String)"Disable JavaScript in less files");
        result.addOption(OptionBuilder.create());
        result.addOption("l", LINT_OPTION, false, "Syntax check only (lint).");
        result.addOption("s", SILENT_OPTION, false, "Suppress output of error messages.");
        OptionBuilder.withLongOpt((String)STRICT_IMPORTS_OPTION);
        OptionBuilder.withDescription((String)"Force evaluation of imports.");
        result.addOption(OptionBuilder.create());
        result.addOption("v", VERSION_OPTION, false, "Print version number and exit.");
        result.addOption("x", COMPRESS_OPTION, false, "Compress output by removing some whitespaces.");
        OptionBuilder.withLongOpt((String)SOURCE_MAP_OPTION);
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"--source-map[=FILENAME] Outputs a v3 sourcemap to the filename (or output filename.map)");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)SOURCE_MAP__ROOTPATH_OPTION);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"adds this path onto the sourcemap filename and less file paths");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)SOURCE_MAP__BASEPATH_OPTION);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Sets sourcemap base path, defaults to current working directory.");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)SOURCE_MAP_LESS_INLINE_OPTION);
        OptionBuilder.withDescription((String)"puts the less files into the map instead of referencing them");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)SOURCE_MAP_MAP_INLINE_OPTION);
        OptionBuilder.withDescription((String)"puts the map (and any less files) into the output css file");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)SOURCE_MAP_URL_OPTION);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the complete url and filename put in the less file");
        result.addOption(OptionBuilder.create());
        result.addOption("rp", ROOT_PATH_OPTION, true, "Set rootpath for url rewriting in relative imports and urls. Works with or without the relative-urls option.");
        result.addOption("ru", RELATIVE_URLS_OPTION, false, "re-write relative urls to the base less file.");
        result.addOption("sm", STRICT_MATH_OPTION, false, "Turn on or off strict math, where in strict mode, math requires brackets. This option may default to on and then be removed in the future.");
        result.addOption("su", STRICT_UNITS_OPTION, false, "Allow mixed units, e.g. 1px+1em or 1px*1px which have units that cannot be represented.");
        OptionBuilder.withLongOpt((String)GLOBAL_VAR_OPTION);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"--global-var='VAR=VALUE' Defines a variable that can be referenced by the file.");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)MODIFY_VAR_OPTION);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"--modify-var='VAR=VALUE' Modifies a variable already declared in the file.");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)VERBOSE_OPTION);
        OptionBuilder.withDescription((String)"Be verbose.");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)YUI_COMPRESS_OPTION);
        OptionBuilder.withDescription((String)"Compress output using YUI cssmin.");
        result.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)OPTIMIZATION_LEVEL_OPTION);
        OptionBuilder.withType(Number.class);
        OptionBuilder.withDescription((String)"[deprecated] -O0, -O1, -O2; Set the parser's optimization level. The lower the number, the less nodes it will create in the tree. This could matter for debugging, or if you want to access the individual nodes in the tree.");
        result.addOption(OptionBuilder.create((char)'O'));
        OptionBuilder.withLongOpt((String)LINE_NUMBERS_OPTION);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"[deprecated] --line-numbers=TYPE Outputs filename and line numbers. TYPE can be either 'comments', which will output the debug info within comments, 'mediaquery' that will output the information within a fake media query which is compatible with the SASS format, and 'all' which will do both.");
        result.addOption(OptionBuilder.create());
        result.addOption("js", CUSTOM_JS_OPTION, true, "File with custom JavaScript functions.");
        result.addOption("e", ENCODING_OPTION, true, "Character encoding.");
        OptionBuilder.withLongOpt((String)CACHE_DIR_OPTION);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Cache directory.");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)DAEMON_OPTION);
        OptionBuilder.withDescription((String)"Start compiler daemon.");
        result.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)ENGINE_OPTION);
        OptionBuilder.withDescription((String)"JavaScript engine, either 'rhino' (default), 'nashorn' (requires JDK8) or 'commandline'.");
        result.addOption(OptionBuilder.create());
        return result;
    }

    private CommandLine parseCommandLine(String[] args, org.apache.commons.cli.Options cliOptions) throws ParseException {
        GnuParser parser = new GnuParser();
        return parser.parse(cliOptions, args);
    }

    private boolean printVersion(CommandLine cmd) {
        if (cmd.hasOption(VERSION_OPTION)) {
            System.out.println(this.version);
            return true;
        }
        return false;
    }

    private boolean printHelp(CommandLine cmd, org.apache.commons.cli.Options options) {
        if (cmd.hasOption(HELP_OPTION)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(MAIN_COMMAND, HELP_HEADER, options, HELP_FOOTER);
            return true;
        }
        return false;
    }

    public static void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(MAIN_COMMAND, HELP_HEADER, LesscCommandLineParser.createOptions(), HELP_FOOTER);
    }

    private void process(CommandLine cmd) throws ParseException, IOException {
        this.setSourceLocation(cmd);
        this.setDestinationFile(cmd);
        this.setVerbosity(cmd);
        this.setOptions(cmd);
        this.setEncoding(cmd);
        this.setResourceReader(cmd);
        this.setCustomJsReader(cmd);
        this.setCacheDir(cmd);
        this.setDaemon(cmd);
        this.setEngine(cmd);
        this.checkSourceLocation();
    }

    private void setSourceLocation(CommandLine cmd) throws ParseException {
        if (cmd.getArgs().length < 1) {
            throw new ParseException("<source> is not specified");
        }
        this.sourceLocation = cmd.getArgs()[0];
    }

    private void setDestinationFile(CommandLine cmd) {
        if (cmd.getArgs().length > 1) {
            this.destination = new File(cmd.getArgs()[1]);
        }
    }

    private void setVerbosity(CommandLine cmd) {
        this.verbose = cmd.hasOption(VERBOSE_OPTION);
        LogbackConfigurator.configure(this.verbose && this.destination != null, cmd.hasOption(DAEMON_OPTION));
    }

    private void setOptions(CommandLine cmd) throws ParseException {
        this.options = new Options();
        this.options.setDependenciesOnly(cmd.hasOption(DEPENDS_OPTION));
        this.options.setIeCompat(!cmd.hasOption(NO_IE_COMPAT_OPTION));
        this.options.setJavascriptEnabled(!cmd.hasOption(NO_JS_OPTION));
        this.options.setLint(cmd.hasOption(LINT_OPTION));
        this.options.setSilent(cmd.hasOption(SILENT_OPTION));
        this.options.setStrictImports(cmd.hasOption(STRICT_IMPORTS_OPTION));
        this.options.setCompress(cmd.hasOption(COMPRESS_OPTION));
        this.options.setSourceMap(cmd.hasOption(SOURCE_MAP_OPTION));
        this.options.setSourceMapRootpath(cmd.getOptionValue(SOURCE_MAP__ROOTPATH_OPTION));
        this.options.setSourceMapBasepath(cmd.getOptionValue(SOURCE_MAP__BASEPATH_OPTION));
        this.options.setSourceMapLessInline(cmd.hasOption(SOURCE_MAP_LESS_INLINE_OPTION));
        this.options.setSourceMapMapInline(cmd.hasOption(SOURCE_MAP_MAP_INLINE_OPTION));
        this.options.setSourceMapURL(cmd.getOptionValue(SOURCE_MAP_URL_OPTION));
        if (this.options.isSourceMap() && !this.options.isSourceMapMapInline()) {
            String sourceMapFileName = cmd.getOptionValue(SOURCE_MAP_OPTION);
            if (sourceMapFileName == null) {
                if (this.destination == null) {
                    throw new ParseException("The sourcemap option only has an optional filename if the css filename is given");
                }
                this.sourceMapFile = new File(this.getDestination().getParentFile(), this.getDestination().getName() + ".map");
            } else {
                this.sourceMapFile = new File(sourceMapFileName);
            }
        }
        this.options.setRootpath(cmd.getOptionValue(ROOT_PATH_OPTION));
        this.options.setRelativeUrls(cmd.hasOption(RELATIVE_URLS_OPTION));
        this.options.setStrictMath(cmd.hasOption(STRICT_MATH_OPTION));
        this.options.setStrictUnits(cmd.hasOption(STRICT_UNITS_OPTION));
        this.options.setGlobalVars(this.getValuesMap(cmd.getOptionValues(GLOBAL_VAR_OPTION)));
        this.options.setModifyVars(this.getValuesMap(cmd.getOptionValues(MODIFY_VAR_OPTION)));
        this.options.setMinify(cmd.hasOption(YUI_COMPRESS_OPTION));
        if (cmd.hasOption(OPTIMIZATION_LEVEL_OPTION)) {
            this.options.setOptimizationLevel(((Long)cmd.getParsedOptionValue(OPTIMIZATION_LEVEL_OPTION)).intValue());
        }
        if (cmd.hasOption(LINE_NUMBERS_OPTION)) {
            this.options.setDumpLineNumbers(Options.LineNumbersOutput.fromOptionString(cmd.getOptionValue(LINE_NUMBERS_OPTION)));
        }
    }

    private Map<String, String> getValuesMap(String[] args) throws ParseException {
        HashMap<String, String> values = new HashMap<String, String>();
        if (args != null) {
            for (String arg : args) {
                Matcher matcher = this.nameValuePattern.matcher(arg);
                if (!matcher.matches()) continue;
                values.put(matcher.group(2), matcher.group(3));
            }
        }
        return values;
    }

    private void setEncoding(CommandLine cmd) {
        this.encoding = cmd.getOptionValue(ENCODING_OPTION);
    }

    private void setResourceReader(CommandLine cmd) throws ParseException {
        if (cmd.hasOption(INCLUDE_PATH_OPTION)) {
            String[] paths = cmd.getOptionValue(INCLUDE_PATH_OPTION).split("[:|;]");
            File[] files = new File[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                files[i] = new File(paths[i]);
            }
            this.resourceReader = new FileSystemResourceReader(this.encoding, files);
        } else {
            File source = new File(this.sourceLocation);
            if (!source.exists()) {
                throw new ParseException(this.sourceLocation + " can not be found. Check the location or use --" + INCLUDE_PATH_OPTION);
            }
            this.resourceReader = new FileSystemResourceReader(this.encoding, source.getAbsoluteFile().getParentFile());
        }
    }

    private void setCustomJsReader(CommandLine cmd) {
        if (cmd.hasOption(CUSTOM_JS_OPTION)) {
            try {
                this.customJsReader = new FileReader(new File(cmd.getOptionValue(CUSTOM_JS_OPTION)));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Custom JavaScript file " + cmd.getOptionValue(CUSTOM_JS_OPTION) + " could not be read", e);
            }
        }
    }

    private void setCacheDir(CommandLine cmd) {
        if (cmd.hasOption(CACHE_DIR_OPTION)) {
            this.cacheDir = new File(cmd.getOptionValue(CACHE_DIR_OPTION));
        }
    }

    private void setDaemon(CommandLine cmd) throws ParseException {
        this.daemon = cmd.hasOption(DAEMON_OPTION);
        if (this.daemon && this.destination == null) {
            throw new ParseException("option --daemon requires an output path to be specified");
        }
        if (this.daemon && this.options.isDependenciesOnly()) {
            throw new ParseException("option --daemon cannot be used together with -M or --depends option");
        }
    }

    private void setEngine(CommandLine cmd) {
        this.engine = cmd.getOptionValue(ENGINE_OPTION);
    }

    private void checkSourceLocation() throws ParseException, IOException {
        if (!this.resourceReader.canRead(this.sourceLocation)) {
            throw new ParseException(this.sourceLocation + " can not be read");
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public File getSourceMapFile() {
        return this.sourceMapFile;
    }

    public File getDestination() {
        return this.destination;
    }

    public ResourceReader getResourceReader() {
        return this.resourceReader;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Reader getCustomJsReader() {
        return this.customJsReader;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public String getEngine() {
        return this.engine;
    }
}

