/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.lombok.ex.processor;

import com.github.houbb.lombok.ex.annotation.UnsupportedOperation;
import com.github.houbb.lombok.ex.metadata.LMethod;
import com.github.houbb.lombok.ex.processor.BaseMethodProcessor;
import com.github.houbb.lombok.ex.util.AstUtil;
import com.github.houbb.lombok.ex.util.ExceptionUtil;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;

@SupportedAnnotationTypes(value={"com.github.houbb.lombok.ex.annotation.UnsupportedOperation"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class UnsupportedOperationProcessor
extends BaseMethodProcessor {
    @Override
    protected Class<? extends Annotation> getAnnotationClass() {
        return UnsupportedOperation.class;
    }

    @Override
    protected void handleMethod(LMethod method) {
        Symbol.MethodSymbol element = method.methodSymbol();
        Class<UnsupportedOperationException> clazz = UnsupportedOperationException.class;
        String fullClassName = clazz.getName();
        AstUtil.importPackage(this.processContext, element, fullClassName);
        AstUtil.importPackage(this.processContext, element, ExceptionUtil.class.getName());
        this.generateBlockCode(clazz, (Element)element);
    }

    private void generateBlockCode(final Class clazz, Element element) {
        final TreeMaker treeMaker = this.processContext.treeMaker();
        final Names names = this.processContext.names();
        JavacTrees trees = this.processContext.trees();
        JCTree tree = (JCTree)((Trees)trees).getTree(element);
        tree.accept(new TreeTranslator(){

            @Override
            public void visitBlock(JCTree.JCBlock tree) {
                ListBuffer<JCTree.JCExpressionStatement> statements = new ListBuffer<JCTree.JCExpressionStatement>();
                statements.addAll(tree.getStatements());
                JCTree.JCFieldAccess fieldAccess = treeMaker.Select((JCTree.JCExpression)treeMaker.Ident(names.fromString("ExceptionUtil")), names.fromString("throwException"));
                ListBuffer<JCTree.JCFieldAccess> argListBuffer = new ListBuffer<JCTree.JCFieldAccess>();
                String className = clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1);
                JCTree.JCIdent classIdent = treeMaker.Ident(names.fromString(className));
                JCTree.JCFieldAccess argFieldAccess = treeMaker.Select((JCTree.JCExpression)classIdent, names.fromString("class"));
                argListBuffer.add(argFieldAccess);
                JCTree.JCMethodInvocation methodInvocation = treeMaker.Apply(List.nil(), fieldAccess, argListBuffer.toList());
                JCTree.JCExpressionStatement code = treeMaker.Exec(methodInvocation);
                statements.add(code);
                this.result = treeMaker.Block(0L, statements.toList());
            }
        });
    }

    @Deprecated
    private void generateBlockCode(final String fullClassName, Element element) {
        final TreeMaker treeMaker = this.processContext.treeMaker();
        final Names names = this.processContext.names();
        JavacTrees trees = this.processContext.trees();
        JCTree tree = (JCTree)((Trees)trees).getTree(element);
        tree.accept(new TreeTranslator(){

            @Override
            public void visitBlock(JCTree.JCBlock tree) {
                Method[] methods;
                JCTree.JCNewClass jcNewClass;
                ListBuffer<JCTree.JCStatement> statements = new ListBuffer<JCTree.JCStatement>();
                for (int i = 0; i < ((List)tree.getStatements()).size(); ++i) {
                    JCTree.JCStatement statement = (JCTree.JCStatement)((List)tree.getStatements()).get(i);
                    statements.append(statement);
                }
                String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
                JCTree.JCIdent jcIdent = treeMaker.Ident(names.fromString(className));
                JCTree.JCNewClass jcTree = jcNewClass = treeMaker.NewClass(null, null, jcIdent, List.nil(), null);
                for (Method method : methods = treeMaker.getClass().getMethods()) {
                    if (!method.getName().startsWith("Throw")) continue;
                    System.out.println(method.getName());
                    System.out.println(Arrays.toString(method.getParameterTypes()));
                }
                JCTree.JCThrow jcThrow = treeMaker.Throw(jcTree);
                statements.add(jcThrow);
                this.result = treeMaker.Block(0L, statements.toList());
            }
        });
    }
}

