/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.lombok.ex.processor;

import com.github.houbb.heaven.support.tuple.impl.Pair;
import com.github.houbb.heaven.util.io.StreamUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.lombok.ex.annotation.SPIAuto;
import com.github.houbb.lombok.ex.exception.LombokExException;
import com.github.houbb.lombok.ex.metadata.LClass;
import com.github.houbb.lombok.ex.processor.BaseClassProcessor;
import com.github.houbb.spi.annotation.SPI;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.github.houbb.lombok.ex.annotation.SPIAuto"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class SPIAutoProcessor
extends BaseClassProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        java.util.List<LClass> classList = super.getClassList(roundEnv, this.getAnnotationClass());
        HashMap<String, Set<String>> spiClassMap = new HashMap<String, Set<String>>();
        for (LClass lClass : classList) {
            String spiClassName = this.getSpiClassName(lClass);
            String fullName = lClass.classSymbol().fullname.toString();
            if (StringUtil.isEmpty((String)spiClassName)) {
                throw new LombokExException("@SPI class not found for class: " + fullName);
            }
            Pair<String, String> aliasAndDirPair = this.getAliasAndDir(lClass);
            String newLine = (String)aliasAndDirPair.getValueOne() + "=" + fullName;
            String filePath = (String)aliasAndDirPair.getValueTwo() + spiClassName;
            HashSet<String> lineSet = (HashSet<String>)spiClassMap.get(filePath);
            if (lineSet == null) {
                lineSet = new HashSet<String>();
            }
            lineSet.add(newLine);
            spiClassMap.put(filePath, lineSet);
        }
        this.generateNewFiles(spiClassMap);
        return true;
    }

    @Override
    protected Class<? extends Annotation> getAnnotationClass() {
        return SPIAuto.class;
    }

    private Pair<String, String> getAliasAndDir(LClass lClass) {
        SPIAuto auto = lClass.classSymbol().getAnnotation(SPIAuto.class);
        String fullClassName = lClass.classSymbol().fullname.toString();
        String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf("."));
        String alias = auto.value();
        if (StringUtil.isEmpty((String)alias)) {
            alias = StringUtil.firstToLowerCase((String)simpleClassName);
        }
        return Pair.of((Object)alias, (Object)auto.dir());
    }

    private void generateNewFiles(Map<String, Set<String>> spiClassMap) {
        Filer filer = this.processingEnv.getFiler();
        for (Map.Entry<String, Set<String>> entry : spiClassMap.entrySet()) {
            String fullFilePath = entry.getKey();
            Set<String> newLines = entry.getValue();
            try {
                FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", fullFilePath);
                System.out.println("Looking for existing resource file at " + existingFile.toUri());
                HashSet oldLines = new HashSet(StreamUtil.readAllLines((InputStream)existingFile.openInputStream()));
                System.out.println("Looking for existing resource file set " + oldLines);
                newLines.addAll(oldLines);
                StreamUtil.write(newLines, (OutputStream)existingFile.openOutputStream());
                return;
            }
            catch (IOException e) {
                System.out.println("Resources file not exists.");
                try {
                    FileObject newFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", fullFilePath, new Element[0]);
                    try {
                        OutputStream outputStream = newFile.openOutputStream();
                        Throwable throwable = null;
                        try {
                            StreamUtil.write(newLines, (OutputStream)outputStream);
                            System.out.println("Write into file " + newFile.toUri());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (outputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            outputStream.close();
                        }
                    }
                    catch (IOException e2) {
                        throw new LombokExException(e2);
                    }
                }
                catch (IOException e3) {
                    throw new LombokExException(e3);
                }
            }
        }
    }

    private String getSpiClassName(LClass lClass) {
        java.util.List typeList = lClass.classSymbol().getInterfaces();
        if (null == typeList || ((List)typeList).isEmpty()) {
            return "";
        }
        SPIAuto auto = lClass.classSymbol().getAnnotation(SPIAuto.class);
        for (Type type : typeList) {
            Symbol.ClassSymbol tsym = (Symbol.ClassSymbol)type.tsym;
            if (tsym.getAnnotation(SPI.class) == null) continue;
            return tsym.fullname.toString();
        }
        return "";
    }
}

