/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.lombok.ex.util;

import com.github.houbb.heaven.annotation.CommonEager;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.lang.reflect.ReflectFieldUtil;
import com.github.houbb.heaven.util.lang.reflect.ReflectMethodUtil;
import com.github.houbb.lombok.ex.exception.LombokExException;
import com.github.houbb.lombok.ex.util.JavacUtil;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class AstReflectUtil {
    private AstReflectUtil() {
    }

    public static JCTree.JCBinary invokeJcBinary(TreeMaker treeMaker, String fieldName, JCTree.JCExpression lhs, JCTree.JCExpression rhs) {
        Object treeTag = AstReflectUtil.getTreeTag(fieldName);
        Method method = AstReflectUtil.getJcBinaryMethod();
        return (JCTree.JCBinary)ReflectMethodUtil.invoke((Object)treeMaker, (Method)method, (Object[])new Object[]{treeTag, lhs, rhs});
    }

    private static Method getJcBinaryMethod() {
        try {
            int version = JavacUtil.getJavaCompilerVersion();
            String methodName = "Binary";
            if (version < 8) {
                return ClassUtil.getMethod(TreeMaker.class, (String)"Binary", (Class[])new Class[]{Integer.TYPE, JCTree.JCExpression.class, JCTree.JCExpression.class});
            }
            String className = "com.sun.tools.javac.tree.JCTree$Tag";
            Class<?> tagClass = Class.forName(className);
            return ClassUtil.getMethod(TreeMaker.class, (String)"Binary", (Class[])new Class[]{tagClass, JCTree.JCExpression.class, JCTree.JCExpression.class});
        }
        catch (ClassNotFoundException e) {
            throw new LombokExException(e);
        }
    }

    private static Object getTreeTag(String fieldName) {
        int version = JavacUtil.getJavaCompilerVersion();
        if (version < 8) {
            String className = "com.sun.tools.javac.tree.JCTree";
            return AstReflectUtil.getStaticFieldValue(className, fieldName);
        }
        String className = "com.sun.tools.javac.tree.JCTree$Tag";
        return AstReflectUtil.getEnumConstValue(className, fieldName);
    }

    @CommonEager
    public static Object getStaticFieldValue(String className, String fieldName) {
        try {
            Class<?> clazz = Class.forName(className);
            Field field = ReflectFieldUtil.getField(clazz, (String)fieldName);
            return ReflectFieldUtil.getValue((Field)field, null);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @CommonEager
    public static Object getEnumConstValue(String className, String enumName) {
        try {
            ?[] objects;
            Class<?> clazz = Class.forName(className);
            for (Object object : objects = clazz.getEnumConstants()) {
                if (!enumName.equalsIgnoreCase(object.toString())) continue;
                return object;
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static String treeTagClass() {
        return JavacUtil.getJavaCompilerVersion() < 8 ? "com.sun.tools.javac.tree.JCTree" : "com.sun.tools.javac.tree.JCTree$Tag";
    }
}

