/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.lombok.ex.metadata;

import com.github.houbb.lombok.ex.metadata.LClass;
import com.github.houbb.lombok.ex.model.ProcessContext;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Names;
import javax.annotation.processing.Messager;

public class LCommon {
    protected Messager messager;
    protected JavacTrees trees;
    protected TreeMaker treeMaker;
    protected Names names;

    public LCommon(ProcessContext processContext) {
        this.treeMaker = processContext.treeMaker();
        this.trees = processContext.trees();
        this.names = processContext.names();
        this.messager = processContext.messager();
    }

    public void importPackage(LClass lClass, Class<?> importClass) {
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)this.trees.getPath(lClass.classSymbol()).getCompilationUnit();
        ListBuffer<JCTree> imports = new ListBuffer<JCTree>();
        JCTree.JCIdent packageIdent = this.treeMaker.Ident(this.names.fromString(importClass.getPackage().getName()));
        JCTree.JCFieldAccess fieldAccess = this.treeMaker.Select((JCTree.JCExpression)packageIdent, this.names.fromString(importClass.getSimpleName()));
        JCTree.JCImport jcImport = this.treeMaker.Import(fieldAccess, false);
        imports.append(jcImport);
        for (int i = 0; i < compilationUnit.defs.size(); ++i) {
            imports.append(compilationUnit.defs.get(i));
        }
        compilationUnit.defs = imports.toList();
    }
}

