/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.lombok.ex.processor;

import com.github.houbb.lombok.ex.metadata.LMethod;
import com.github.houbb.lombok.ex.processor.BaseProcessor;
import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public abstract class BaseMethodProcessor
extends BaseProcessor {
    protected abstract Class<? extends Annotation> getAnnotationClass();

    protected abstract void handleMethod(LMethod var1);

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        List<LMethod> methodList = this.getMethodList(roundEnv, this.getAnnotationClass());
        for (LMethod method : methodList) {
            this.handleMethod(method);
        }
        return true;
    }

    protected List<LMethod> getMethodList(RoundEnvironment roundEnv, Class<? extends Annotation> annotationClass) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(annotationClass);
        ArrayList<LMethod> methodList = new ArrayList<LMethod>(elements.size());
        for (Element element : elements) {
            if (element.getKind() != ElementKind.METHOD || !(element instanceof Symbol.MethodSymbol)) continue;
            methodList.add(new LMethod(this.processContext, (Symbol.MethodSymbol)element));
        }
        return methodList;
    }
}

