/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.reflect.util;

import com.github.houbb.heaven.reflect.api.IField;
import com.github.houbb.heaven.reflect.exception.ReflectRuntimeException;
import com.github.houbb.heaven.reflect.handler.SimpleFieldHandler;
import com.github.houbb.heaven.reflect.simple.SimpleField;
import com.github.houbb.heaven.support.cache.impl.ClassFieldListCache;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.lang.reflect.Field;
import java.util.List;

public final class Classes {
    private Classes() {
    }

    public static List<IField> getFields(Class clazz) {
        ArgUtil.notNull(clazz, "clazz");
        List fieldList = (List)ClassFieldListCache.getInstance().get(clazz);
        List<IField> resultList = Guavas.newArrayList(fieldList.size());
        SimpleFieldHandler handler = new SimpleFieldHandler();
        for (Field field : fieldList) {
            SimpleField result = handler.handle(field);
            resultList.add(result);
        }
        return resultList;
    }

    public static void initFieldValue(Object target, List<IField> fieldList) {
        if (CollectionUtil.isNotEmpty(fieldList)) {
            try {
                for (IField field : fieldList) {
                    Object value = field.field().get(target);
                    field.value(value);
                }
            }
            catch (IllegalAccessException e) {
                throw new ReflectRuntimeException(e);
            }
        }
    }
}

