/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.util;

import com.github.houbb.compress.bs.CompressBs;
import com.github.houbb.compress.constant.enums.CompressTypeEnum;
import com.github.houbb.compress.support.result.uncompress.IUncompressResultHandler;
import com.github.houbb.compress.support.result.uncompress.impl.UncompressResultHandlers;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.io.StreamUtil;
import java.io.Closeable;
import java.io.InputStream;

public final class CompressStreamHelper {
    private CompressStreamHelper() {
    }

    public static String uncompress(String sourcePath) {
        return CompressStreamHelper.uncompress(CompressTypeEnum.ZIP, sourcePath);
    }

    public static String uncompress(CompressTypeEnum compressTypeEnum, String sourcePath) {
        return CompressStreamHelper.uncompress(compressTypeEnum, sourcePath, UncompressResultHandlers.stringFirst());
    }

    public static <R> R uncompress(CompressTypeEnum compressTypeEnum, String sourcePath, IUncompressResultHandler<R> handler) {
        ArgUtil.notEmpty((String)sourcePath, (String)"sourcePath");
        InputStream inputStream = StreamUtil.getInputStream((String)sourcePath);
        return CompressStreamHelper.uncompress(compressTypeEnum, inputStream, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R uncompress(CompressTypeEnum compressTypeEnum, InputStream sourceStream, IUncompressResultHandler<R> handler) {
        ArgUtil.notNull((Object)((Object)compressTypeEnum), (String)"compressTypeEnum");
        ArgUtil.notNull((Object)sourceStream, (String)"sourceStream");
        ArgUtil.notNull(handler, (String)"handler");
        try {
            R r = CompressBs.newInstance(compressTypeEnum).uncompressStream(sourceStream).target("/").createFile(false).uncompress(handler);
            return r;
        }
        finally {
            StreamUtil.closeStream((Closeable)sourceStream);
        }
    }
}

