/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.support.result.uncompress.impl;

import com.github.houbb.compress.api.IUncompressResult;
import com.github.houbb.compress.support.result.uncompress.IUncompressResultHandler;
import com.github.houbb.compress.support.result.uncompress.impl.BytesFirstUncompressResultHandler;
import com.github.houbb.compress.support.result.uncompress.impl.StringFirstUncompressResultHandler;
import com.github.houbb.compress.support.result.uncompress.impl.UncompressResultHandler;
import com.github.houbb.heaven.support.instance.impl.Instances;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class UncompressResultHandlers {
    private UncompressResultHandlers() {
    }

    public static IUncompressResultHandler<IUncompressResult> defaults() {
        return (IUncompressResultHandler)Instances.singleton(UncompressResultHandler.class);
    }

    public static IUncompressResultHandler<byte[]> bytesFirst() {
        return (IUncompressResultHandler)Instances.singleton(BytesFirstUncompressResultHandler.class);
    }

    public static IUncompressResultHandler<String> stringFirst(String charsetString) {
        Charset charset = Charset.forName(charsetString);
        return new StringFirstUncompressResultHandler(charset);
    }

    public static IUncompressResultHandler<String> stringFirst() {
        return new StringFirstUncompressResultHandler(StandardCharsets.UTF_8);
    }
}

