/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.bs;

import com.github.houbb.compress.api.ICompress;
import com.github.houbb.compress.api.ICompressResult;
import com.github.houbb.compress.api.IUncompressResult;
import com.github.houbb.compress.api.impl.Compress;
import com.github.houbb.compress.bs.CompressContextBs;
import com.github.houbb.compress.constant.enums.CompressTypeEnum;
import com.github.houbb.compress.support.result.compress.ICompressResultHandler;
import com.github.houbb.compress.support.result.uncompress.IUncompressResultHandler;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.common.ArgUtil;
import java.io.InputStream;

public final class CompressBs {
    private CompressTypeEnum compressType;
    private String[] compressSources;
    private String target;
    private String password = null;
    private boolean relativePath = true;
    private boolean createFile = true;
    private ICompress compress = (ICompress)Instances.singleton(Compress.class);
    private InputStream uncompressStream;

    private CompressBs() {
    }

    public static CompressBs newInstance(CompressTypeEnum compressTypeEnum) {
        CompressBs compressBs = new CompressBs();
        compressBs.compressType = compressTypeEnum;
        return compressBs;
    }

    private CompressBs compressType(CompressTypeEnum compressTypeEnum) {
        ArgUtil.notNull((Object)((Object)compressTypeEnum), (String)"compressTypeEnum");
        this.compressType = compressTypeEnum;
        return this;
    }

    public CompressBs compressSources(String ... sources) {
        ArgUtil.notEmpty((Object[])sources, (String)"sources");
        this.compressSources = sources;
        return this;
    }

    public CompressBs uncompressStream(InputStream uncompressStream) {
        ArgUtil.notNull((Object)uncompressStream, (String)"uncompressStream");
        this.uncompressStream = uncompressStream;
        return this;
    }

    public CompressBs target(String target) {
        ArgUtil.notEmpty((String)target, (String)"target");
        this.target = target;
        return this;
    }

    public CompressBs password(String password) {
        ArgUtil.notEmpty((String)password, (String)"password");
        this.password = password;
        return this;
    }

    public CompressBs relativePath(boolean relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    public CompressBs createFile(boolean createFile) {
        this.createFile = createFile;
        return this;
    }

    public <R> R compress(ICompressResultHandler<R> handler) {
        CompressContextBs context = this.buildCompressContextBs();
        ICompressResult result = this.compress.compress(context);
        return handler.handler(result);
    }

    public <R> R uncompress(IUncompressResultHandler<R> handler) {
        CompressContextBs context = this.buildUnompressContextBs();
        context.uncompressStream();
        IUncompressResult result = this.compress.uncompress(context);
        return handler.handler(result);
    }

    private CompressContextBs buildCompressContextBs() {
        return CompressContextBs.newInstance().relativePath(this.relativePath).compressSources(this.compressSources).target(this.target).compressType(this.compressType).password(this.password).createFile(this.createFile);
    }

    private CompressContextBs buildUnompressContextBs() {
        return CompressContextBs.newInstance().relativePath(this.relativePath).target(this.target).compressType(this.compressType).password(this.password).uncompressStream(this.uncompressStream).createFile(this.createFile);
    }
}

