/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.util;

import com.github.houbb.compress.api.ICompressResult;
import com.github.houbb.compress.api.IUncompressResult;
import com.github.houbb.compress.bs.CompressBs;
import com.github.houbb.compress.constant.enums.CompressTypeEnum;
import com.github.houbb.compress.exception.CompressRuntimeException;
import com.github.houbb.compress.support.result.compress.impl.CompressResultHandlers;
import com.github.houbb.compress.support.result.uncompress.impl.UncompressResultHandlers;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.io.FileUtil;
import com.github.houbb.heaven.util.io.StreamUtil;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CompressHelper {
    private CompressHelper() {
    }

    public static ICompressResult compress(String source) {
        String target = FileUtil.getDirPath((String)source) + FileUtil.getFileName((String)source) + "." + CompressTypeEnum.ZIP.fileSuffix();
        return CompressHelper.compress(CompressTypeEnum.ZIP, source, target);
    }

    public static ICompressResult compress(String source, String target) {
        String fileSuffix = FileUtil.getSuffix((String)target);
        CompressTypeEnum compressTypeEnum = CompressTypeEnum.of(fileSuffix);
        return CompressHelper.compress(compressTypeEnum, source, target);
    }

    public static ICompressResult compress(CompressTypeEnum compressTypeEnum, String source, String target) {
        ArgUtil.notNull((Object)((Object)compressTypeEnum), (String)"compressTypeEnum");
        ArgUtil.notEmpty((String)source, (String)"source");
        ArgUtil.notEmpty((String)target, (String)"target");
        return CompressBs.newInstance(compressTypeEnum).compressSources(source).target(target).compress(CompressResultHandlers.defaults());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IUncompressResult uncompress(CompressTypeEnum compressTypeEnum, String source, String targetDir) {
        ArgUtil.notNull((Object)((Object)compressTypeEnum), (String)"compressTypeEnum");
        ArgUtil.notEmpty((String)source, (String)"source");
        ArgUtil.notEmpty((String)targetDir, (String)"target");
        try (FileInputStream inputStream = new FileInputStream(source);){
            IUncompressResult iUncompressResult = CompressHelper.uncompress(compressTypeEnum, inputStream, targetDir);
            return iUncompressResult;
        }
        catch (IOException e) {
            throw new CompressRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IUncompressResult uncompress(CompressTypeEnum compressTypeEnum, InputStream sourceStream, String targetDir) {
        ArgUtil.notNull((Object)((Object)compressTypeEnum), (String)"compressTypeEnum");
        ArgUtil.notNull((Object)sourceStream, (String)"sourceStream");
        ArgUtil.notEmpty((String)targetDir, (String)"target");
        try {
            IUncompressResult iUncompressResult = CompressBs.newInstance(compressTypeEnum).uncompressStream(sourceStream).target(targetDir).uncompress(UncompressResultHandlers.defaults());
            return iUncompressResult;
        }
        finally {
            StreamUtil.closeStream((Closeable)sourceStream);
        }
    }

    public static IUncompressResult uncompress(String source, String targetDir) {
        String fileSuffix = FileUtil.getSuffix((String)source);
        CompressTypeEnum compressTypeEnum = CompressTypeEnum.of(fileSuffix);
        return CompressHelper.uncompress(compressTypeEnum, source, targetDir);
    }

    public static IUncompressResult uncompress(String source) {
        String targetDir = FileUtil.getDirPath((String)source);
        return CompressHelper.uncompress(source, targetDir);
    }
}

