/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.constant.enums;

import com.github.houbb.compress.exception.CompressRuntimeException;

public enum CompressTypeEnum {
    JAR("jar"),
    SEVENZ("7z"),
    ZIP("zip"),
    TAR("tar");

    private final String fileSuffix;

    private CompressTypeEnum(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public String fileSuffix() {
        return this.fileSuffix;
    }

    public static CompressTypeEnum of(String fileSuffix) {
        for (CompressTypeEnum typeEnum : CompressTypeEnum.values()) {
            if (!typeEnum.fileSuffix.equals(fileSuffix)) continue;
            return typeEnum;
        }
        throw new CompressRuntimeException("Not support compress type for: " + fileSuffix);
    }
}

