/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.handler.factory;

import com.github.houbb.compress.constant.CompressTypeEnum;
import com.github.houbb.compress.handler.ICompressHandler;
import com.github.houbb.compress.handler.archive.JarUnArchiveHandler;
import com.github.houbb.compress.handler.archive.ServenZUnArchiveHandler;
import com.github.houbb.compress.handler.archive.TarUnArchiveHandler;
import com.github.houbb.compress.handler.archive.ZipUnArchiveHandler;
import java.util.EnumMap;
import java.util.Map;

public final class UnCompressFactory {
    private static final Map<CompressTypeEnum, ICompressHandler> UNCOMPRESS_MAP = new EnumMap<CompressTypeEnum, ICompressHandler>(CompressTypeEnum.class);

    private UnCompressFactory() {
    }

    public static ICompressHandler getHandler(CompressTypeEnum compressTypeEnum) {
        return UNCOMPRESS_MAP.get((Object)compressTypeEnum);
    }

    static {
        UNCOMPRESS_MAP.put(CompressTypeEnum.JAR, new JarUnArchiveHandler());
        UNCOMPRESS_MAP.put(CompressTypeEnum.SEVENZ, new ServenZUnArchiveHandler());
        UNCOMPRESS_MAP.put(CompressTypeEnum.TAR, new TarUnArchiveHandler());
        UNCOMPRESS_MAP.put(CompressTypeEnum.ZIP, new ZipUnArchiveHandler());
    }
}

