/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.handler.factory;

import com.github.houbb.compress.constant.CompressTypeEnum;
import com.github.houbb.compress.handler.ICompressHandler;
import com.github.houbb.compress.handler.archive.JarArchiveHandler;
import com.github.houbb.compress.handler.archive.ServenZArchiveHandler;
import com.github.houbb.compress.handler.archive.TarArchiveHandler;
import com.github.houbb.compress.handler.archive.ZipArchiveHandler;
import java.util.EnumMap;
import java.util.Map;

public final class CompressFactory {
    private static final Map<CompressTypeEnum, ICompressHandler> COMPRESS_MAP = new EnumMap<CompressTypeEnum, ICompressHandler>(CompressTypeEnum.class);

    private CompressFactory() {
    }

    public static ICompressHandler getHandler(CompressTypeEnum compressTypeEnum) {
        return COMPRESS_MAP.get((Object)compressTypeEnum);
    }

    static {
        COMPRESS_MAP.put(CompressTypeEnum.JAR, new JarArchiveHandler());
        COMPRESS_MAP.put(CompressTypeEnum.SEVENZ, new ServenZArchiveHandler());
        COMPRESS_MAP.put(CompressTypeEnum.TAR, new TarArchiveHandler());
        COMPRESS_MAP.put(CompressTypeEnum.ZIP, new ZipArchiveHandler());
    }
}

