/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.handler.archive;

import com.github.houbb.compress.context.ICompressContext;
import com.github.houbb.compress.exception.CompressRuntimeException;
import com.github.houbb.compress.handler.adaptor.ArchiveHandlerAdaptor;
import com.github.houbb.heaven.support.condition.ICondition;
import com.github.houbb.heaven.util.nio.PathUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;

abstract class AbstractArchiveHandler
extends ArchiveHandlerAdaptor {
    AbstractArchiveHandler() {
    }

    protected abstract ArchiveOutputStream getArchiveOutputStream(File var1, String var2);

    protected abstract ArchiveEntry getArchiveEntry(ArchiveOutputStream var1, File var2, String var3);

    @Override
    public void handle(ICompressContext context) {
        this.doHandle(context);
    }

    protected void doHandle(ICompressContext context) {
        File targetFile = context.targetPath().toFile();
        List<Path> pathList = this.buildAllPaths(context.sourcePaths());
        Path publicParentPath = PathUtil.getPublicParentPath(context.sourcePaths());
        String password = context.password();
        try (ArchiveOutputStream outputStream = this.getArchiveOutputStream(targetFile, password);){
            ArchiveEntry entry = null;
            for (Path path : pathList) {
                File fileToArchive = path.toFile();
                String entryName = this.getEntryName(publicParentPath, fileToArchive, context);
                entry = this.getArchiveEntry(outputStream, fileToArchive, entryName);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    outputStream.putArchiveEntry(entry);
                    continue;
                }
                if (!fileToArchive.isFile()) continue;
                byte[] contentOfEntry = Files.readAllBytes(path);
                outputStream.putArchiveEntry(entry);
                outputStream.write(contentOfEntry);
            }
            if (entry != null) {
                outputStream.closeArchiveEntry();
            }
        }
        catch (IOException e) {
            throw new CompressRuntimeException(e);
        }
    }

    private List<Path> buildAllPaths(List<Path> pathList) {
        ArrayList<Path> resultPaths = new ArrayList<Path>();
        ArrayList allPaths = new ArrayList();
        for (Path path : pathList) {
            allPaths.addAll(PathUtil.getPathList((Path)path));
        }
        List dirList = CollectionUtil.conditionList(allPaths, (ICondition)new ICondition<Path>(){

            public boolean condition(Path path) {
                return Files.isDirectory(path, new LinkOption[0]);
            }
        });
        List fileList = CollectionUtil.conditionList(allPaths, (ICondition)new ICondition<Path>(){

            public boolean condition(Path path) {
                return path.toFile().isFile();
            }
        });
        resultPaths.addAll(dirList);
        resultPaths.addAll(fileList);
        return resultPaths;
    }

    private String getEntryName(Path publicParentPath, File fileToArchive, ICompressContext compressContext) {
        if (compressContext.isRelativePath()) {
            return PathUtil.getRelativePath((Path)publicParentPath, (Path)fileToArchive.toPath());
        }
        return fileToArchive.getPath();
    }
}

