/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.handler.archive;

import com.github.houbb.compress.exception.CompressRuntimeException;
import com.github.houbb.compress.handler.archive.AbstractArchiveHandler;
import com.github.houbb.heaven.annotation.ThreadSafe;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;

@ThreadSafe
public class JarArchiveHandler
extends AbstractArchiveHandler {
    @Override
    protected ArchiveOutputStream getArchiveOutputStream(File targetFile, String password) {
        try {
            return new JarArchiveOutputStream((OutputStream)new FileOutputStream(targetFile));
        }
        catch (FileNotFoundException e) {
            throw new CompressRuntimeException(e);
        }
    }

    @Override
    protected ArchiveEntry getArchiveEntry(ArchiveOutputStream archiveOutputStream, File fileToArchive, String entryName) {
        JarArchiveEntry jarArchiveEntry = new JarArchiveEntry(entryName);
        jarArchiveEntry.setSize(fileToArchive.length());
        return jarArchiveEntry;
    }
}

